#!/bin/bash

DEST_APP_DIR="/usr/local/bin"
DEST_RULES_DIR="/etc/udev/rules.d"
DEST_CONFIG_DIR="/etc/Quantus"
CONFIG_DIR="/etc/Quantus/configurations"

cp -p 71-Quantus.rules $DEST_RULES_DIR/71-Quantus.rules

udevadm control --reload

echo "Installing Quantus..."

if [ ! -f $DEST_CONFIG_DIR ]; then
	mkdir -p $DEST_CONFIG_DIR
fi

if [ ! -f $CONFIG_DIR ]; then
	mkdir $CONFIG_DIR
fi


cp -rp configurations/* $CONFIG_DIR

if [ -f $DEST_APP_DIR/Quantus ]; then
	rm $DEST_APP_DIR/Quantus
fi
ln -s `pwd`/Quantus.sh $DEST_APP_DIR/Quantus

ldconfig -p | grep libgssdp > /dev/null
if [ $? -eq 0 ]; then
echo "libgssdp is already installed"
else
echo "libgssdp is not installed. Install libgssdp if you want to use the Scan feature"
fi

ldconfig -p | grep libxkbcommon-x11 > /dev/null
if [ $? -eq 0 ]; then
echo "libxkbcommon-x11 is already installed"
else
echo "libxkbcommon-x11 is not installed. Install libxkbcommon-x11 that is needed by Quantus"
fi

# Verifica della versione di glibc (glibc 2.31 o superiore)
GLIBC_VERSION=$(ldd --version | head -n 1 | awk '{print $NF}')
REQUIRED_GLIBC_VERSION="2.31"

if [[ "$(echo -e "$GLIBC_VERSION\n$REQUIRED_GLIBC_VERSION" | sort -V | head -n 1)" == "$REQUIRED_GLIBC_VERSION" ]]; then
    echo "glibc version is adequate ($GLIBC_VERSION)"
else
    echo "glibc version is too old. Please install glibc $REQUIRED_GLIBC_VERSION or higher."
fi

# Verifica della versione di glibcxx (glibcxx 3.4.30 o superiore)
GCC_VERSION=$(g++ --version | head -n 1 | awk '{print $NF}')
REQUIRED_GCC_VERSION="3.4.30"

if [[ "$(echo -e "$GCC_VERSION\n$REQUIRED_GCC_VERSION" | sort -V | head -n 1)" == "$REQUIRED_GCC_VERSION" ]]; then
    echo "glibcxx version is adequate ($GCC_VERSION)"
else
    echo "glibcxx version is too old. Please install glibcxx $REQUIRED_GCC_VERSION or higher."
fi

# Verifica della versione di GCC (9.4.0 o superiore)
GCC_INSTALLED_VERSION=$(gcc --version | head -n 1 | awk '{print $NF}')
REQUIRED_GCC="9.4.0"

if [[ "$(echo -e "$GCC_INSTALLED_VERSION\n$REQUIRED_GCC" | sort -V | head -n 1)" == "$REQUIRED_GCC" ]]; then
    echo "GCC version is adequate ($GCC_INSTALLED_VERSION)"
else
    echo "GCC version is too old. Please install GCC $REQUIRED_GCC or higher."
fi

# Verifica della versione di G++ (9.4.0 o superiore)
GPP_INSTALLED_VERSION=$(g++ --version | head -n 1 | awk '{print $NF}')
REQUIRED_GPP="9.4.0"

if [[ "$(echo -e "$GPP_INSTALLED_VERSION\n$REQUIRED_GPP" | sort -V | head -n 1)" == "$REQUIRED_GPP" ]]; then
    echo "G++ version is adequate ($GPP_INSTALLED_VERSION)"
else
    echo "G++ version is too old. Please install G++ $REQUIRED_GPP or higher."
fi

echo "Done" 


exit 0





