/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		traceDataPanel.cpp
*	\brief
*	\author
*
******************************************************************************/

#include "traceDataPanel.h"

#include <QLabel>
#include <QScrollArea>
#include <QPushButton>
#include <QSpacerItem>
#include <QVBoxLayout>
#include <QComboBox>
#include <QSpinBox>
#include <QLineEdit>
#include <QLayoutItem>
#include <QVector>

#include "CAENPushButton.h"


traceDataPanel::traceDataPanel(QWidget *parent)
{
	QVBoxLayout *VerticalLayout = new QVBoxLayout();
	scrolllLayout = new QVBoxLayout();
	this->setLayout(VerticalLayout);
	area = new QScrollArea(this);
	area->setFrameShape(QFrame::NoFrame);

	VerticalLayout->addWidget(area);
	VerticalLayout->setContentsMargins(0, 5, 0, 0);
	scrolllLayout->setContentsMargins(0, 5, 0, 5);	

	data = new QWidget(this);

	connect(this, SIGNAL(NextEvSelected(QString , int )), parent, SLOT(GoToNextEvent(QString, int)));
	
}

void traceDataPanel::addDevice(QString name) {

	QWidget* panel = new QWidget(this);
	QVBoxLayout* panelLayout = new QVBoxLayout();
	panelLayout->setContentsMargins(3, 3, 0, 3);
	panelLayout->setSpacing(3);
	panel->setLayout(panelLayout);
	panel->setContentsMargins(0, 0, 0, 4);

	QHBoxLayout* row1Layout = new QHBoxLayout();
	QHBoxLayout* row2Layout = new QHBoxLayout();
	QHBoxLayout* row3Layout = new QHBoxLayout();
	row1Layout->setContentsMargins(5, 0, 5, 0);
	row1Layout->setSpacing(10);
	row2Layout->setContentsMargins(5, 0, 5, 0);
	row2Layout->setSpacing(10);

	QLabel* label = new QLabel("<b>" + name + "</b>", this);
	row1Layout->addWidget(label);
	mLabels.append(label);
	QSpacerItem* s = new QSpacerItem(40, 5, QSizePolicy::Expanding, QSizePolicy::Minimum);
	row1Layout->addItem(s);
	panelLayout->addLayout(row1Layout);

	QLabel* label1 = new QLabel("Event Number", this);
	mLabels1.append(label1);
	QSpinBox* sbox = new QSpinBox(this);
	sbox->setKeyboardTracking(false);
	sbox->setMinimum(0);
	sbox->setMaximum(1e9);
	sbox->setSingleStep(1);
	connect(sbox, SIGNAL(valueChanged(int)), this, SLOT(EvNumberChanged(int)));
	row2Layout->addWidget(label1);
	row2Layout->addWidget(sbox);
	QSpacerItem* s1 = new QSpacerItem(40, 5, QSizePolicy::Expanding, QSizePolicy::Minimum);
	row2Layout->addItem(s);
	panelLayout->addLayout(row2Layout);

	QLabel* label2 = new QLabel("Timestamp [ns]", this);
	mLabels2.append(label2);
	QLineEdit* l = new QLineEdit(this);
	l->setEnabled(false);
	row3Layout->addWidget(label2);
	row3Layout->addWidget(l);
	QSpacerItem* s2 = new QSpacerItem(40, 5, QSizePolicy::Expanding, QSizePolicy::Minimum);
	row3Layout->addItem(s2);
	panelLayout->addLayout(row3Layout);

	scrolllLayout->addWidget(panel);
	QSpacerItem* s3 = new QSpacerItem(40, 5, QSizePolicy::Expanding, QSizePolicy::Expanding);
	scrolllLayout->addItem(s3);
	
	data->setLayout(scrolllLayout);
	area->setWidget(data);
	area->setWidgetResizable(true);

	mDevNames.append(name);
	mEvNumber.append(sbox);
	mEvTStamp.append(l);
}

void traceDataPanel::setMaxEv(QString name, uint32_t ev) {
	for (int n = 0; n < mDevNames.size(); n++) {
		if (mDevNames.at(n) == name) {
			mEvNumber.at(n)->setMaximum(ev-1);
		}
	}

}

void traceDataPanel::removeDevice(QString name) {
	int index = mDevNames.indexOf(name);
	mDevNames.removeAt(index);
	delete mEvNumber.at(index);
	mEvNumber.removeAt(index);
	delete mEvTStamp.at(index);
	mEvTStamp.removeAt(index);
	delete mLabels.at(index);
	mLabels.removeAt(index);
	delete mLabels1.at(index);
	mLabels1.removeAt(index);
	delete mLabels2.at(index);
	mLabels2.removeAt(index);
	QLayoutItem* item = scrolllLayout->itemAt(index);
	if (item == nullptr)
		return;
	scrolllLayout->removeItem(item);
	delete item;
}

void traceDataPanel::DisableDev(int t) {
	mEvNumber.at(t)->setEnabled(false);
}

void traceDataPanel::EnableDev(int t) {
	mEvNumber.at(t)->setEnabled(true);
}


void traceDataPanel::removeAllDevices() {
	while (1) {
		QLayoutItem* item = scrolllLayout->itemAt(0);
		if (item == nullptr)
			return;
		scrolllLayout->removeItem(item);
		delete item;
	}
	mDevNames.clear();
	for (int i = 0; i < mEvNumber.size(); i++) {
		delete mEvNumber.at(i);
		delete mEvTStamp.at(i);
		delete mLabels.at(i);
		delete mLabels1.at(i);
		delete mLabels2.at(i);
	}
	mEvNumber.clear();
	mEvTStamp.clear();
	mLabels.clear();
	mLabels1.clear();
	mLabels2.clear();

}

void traceDataPanel::showEvData(QString name, int ev, quint64 t) {
	int index = mDevNames.indexOf(name);
	mEvNumber.at(index)->blockSignals(true);
	mEvNumber.at(index)->setValue(ev);
	mEvNumber.at(index)->blockSignals(false);
	if(t!=0)
		mEvTStamp.at(index)->setText(QString("%1").arg(t));
}

void traceDataPanel::EvNumberChanged(int value) {
	QSpinBox* sbox = qobject_cast<QSpinBox*>(sender());
	int index = mEvNumber.indexOf(sbox);
	emit NextEvSelected(mDevNames.at(index), value);
}

traceDataPanel::~traceDataPanel()
{
	delete area;
	delete data;
}


