/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		statisticsPanel.cpp
*	\brief
*	\author
*
******************************************************************************/

#include "statisticsPanel.h"
#include "WaveDump2.h"



statisticsPanel::statisticsPanel(WaveDump2 *parent)
	: QWidget(parent)
	, mWaveDump(parent)
	, mNdevices{}
{
	ui.setupUi(this);

	for (int i = 0; i < mWaveDump->getNConnectedDevices(); i++) {
		mDev_names.push_back("none");
		mChannels.push_back(-1);
	}

	QHeaderView* header = ui.tabWidget_stats->horizontalHeader();
	header->setSectionResizeMode(QHeaderView::Stretch);
	ui.tabWidget_stats->setColumnWidth(0, 125);

	connect(this->ui.pushButton_clear, SIGNAL(clicked()), this, SLOT(clear()));

}

void statisticsPanel::fillDevices(QList<CAENDevice *> dev) {
	ui.tabWidget_stats->clearContents();
	ui.tabWidget_stats->setRowCount(dev.size());
	for (int i = 0; i < dev.size(); i++) {
		QTableWidgetItem *newItem = new QTableWidgetItem(dev.at(i)->getName());
		newItem->setTextAlignment(Qt::AlignHCenter);
		ui.tabWidget_stats->setItem(i, 0, newItem);		
	}
	mNdevices = dev.size();
}

void statisticsPanel::fillDevColumns(const QVector<QString> *dev_names, const QVector<int> *channels) {
	for (int i = 0; i < dev_names->size(); i++) {
		if (mDev_names.at(i) != dev_names->at(i)) {
			mDev_names.replace(i, dev_names->at(i));
			QTableWidgetItem *newItem = new QTableWidgetItem(dev_names->at(i));
			newItem->setTextAlignment(Qt::AlignHCenter);
			ui.tabWidget_stats->setItem(i, 0, newItem);
		}
		if (mChannels.at(i) != channels->at(i)) {
			mChannels.replace(i, channels->at(i));
			QTableWidgetItem *newItem1 = new QTableWidgetItem(QString("%1").arg(channels->at(i)));
			newItem1->setTextAlignment(Qt::AlignHCenter);
			ui.tabWidget_stats->setItem(i, 1, newItem1);
		}
	}
}

void statisticsPanel::showDevStatus(int dev, QString status) {
	QTableWidgetItem* newItem8 = new QTableWidgetItem(status);
	newItem8->setTextAlignment(Qt::AlignHCenter);
	if (status.contains("busy", Qt::CaseInsensitive))
		newItem8->setTextColor(Qt::red);
	else
		newItem8->setTextColor(Qt::green);
	ui.tabWidget_stats->setItem(dev, 8, newItem8);
}

void statisticsPanel::clear() {
	mWaveDump->Stats()->clear();
	showStats();
}

void statisticsPanel::showStats() {
	Statistics *stats = mWaveDump->Stats();
	QDateTime currentTime = QDateTime::currentDateTime();
	uint64_t currentDevTime;
	qint64 timeDiff2;
	qint64 timeDiff1 = mLastUpdateTime.msecsTo(currentTime);
	uint64_t counts_r, counts_p, counts_l, build_miss, bytes;
	double trg_avg, b_avg;
	for (int i = 0; i < mNdevices; i++) {
		counts_r = stats->getReadTrgCnt(i);
		counts_p = stats->getProcTrgCnt(i);
		counts_l = stats->getLostTrgCnt(i);
		build_miss = stats->getBuildMissCnt(i);
		bytes = stats->getReadByteCnt(i);
		if (mWaveDump->OfflineMode) {
			currentDevTime = mWaveDump->getLastEvTimetag(i);
			timeDiff2 = currentDevTime - mLastDevTime[i];
			mLastDevTime[i] = currentDevTime;
			trg_avg = (timeDiff2 == 0) ? 0 : static_cast<double>((counts_r - stats->getReadTrgCnt_prev(i))) / static_cast<double>(timeDiff2);
			if (trg_avg < 0)
				trg_avg = 0;
			//b_avg = (timeDiff2 == 0) ? 0 : static_cast<double>((bytes - stats->getReadByteCnt_prev(i))) / (static_cast<double>(timeDiff2) * 1048.576);
			b_avg = 0;
		}
		else {
			trg_avg = (timeDiff1 == 0) ? 0 : static_cast<double>((counts_r - stats->getReadTrgCnt_prev(i))) / static_cast<double>(timeDiff1);
			b_avg = (timeDiff1 == 0) ? 0 : static_cast<double>((bytes - stats->getReadByteCnt_prev(i))) / (static_cast<double>(timeDiff1) * 1048.576);
		}
		stats->SetReadTrgCnt_prev(i, counts_r);
		stats->SetReadByteCnt_prev(i, bytes);
		QTime T(0, 0, 0);
		QString text = "-";
		if (mWaveDump->isDevAcquiring(i)) {
			T = T.addMSecs(mWaveDump->getAcqtime(i));
			if (!mWaveDump->IsManualOfflineEnabled())
				text = T.toString("hh:mm:ss");
			QTableWidgetItem* newItem1 = new QTableWidgetItem(text);
			newItem1->setTextAlignment(Qt::AlignHCenter);
			ui.tabWidget_stats->setItem(i, 1, newItem1);
		}
		text = "-";
		if (!mWaveDump->IsManualOfflineEnabled())
			text = QString("%1").arg(counts_r);
		QTableWidgetItem *newItem2 = new QTableWidgetItem(text);
		newItem2->setTextAlignment(Qt::AlignHCenter);
		ui.tabWidget_stats->setItem(i, 2, newItem2);
		text = "-";
		if (!mWaveDump->IsManualOfflineEnabled() && !mWaveDump->IsFastSaveEnabled())
			text = QString("%1").arg(counts_p);
		QTableWidgetItem *newItem3 = new QTableWidgetItem(text);
		newItem3->setTextAlignment(Qt::AlignHCenter);
		ui.tabWidget_stats->setItem(i, 3, newItem3);
		text = "-";
		if (!mWaveDump->IsManualOfflineEnabled() && !mWaveDump->IsFastSaveEnabled())
			text = QString("%1").arg(counts_l);
		QTableWidgetItem *newItem4 = new QTableWidgetItem(text);
		newItem4->setTextAlignment(Qt::AlignHCenter);
		ui.tabWidget_stats->setItem(i, 4, newItem4);
		text = "-";
		if (!mWaveDump->IsManualOfflineEnabled() && !mWaveDump->IsFastSaveEnabled())
			text = QString("%1").arg(build_miss);
		QTableWidgetItem *newItem5 = new QTableWidgetItem(text);
		newItem5->setTextAlignment(Qt::AlignHCenter);
		ui.tabWidget_stats->setItem(i, 5, newItem5);
		text = "-";
		if (!mWaveDump->IsManualOfflineEnabled())
			text = QString::number(trg_avg, 'f', 3);
		QTableWidgetItem *newItem6 = new QTableWidgetItem(text); //QString("%1").arg(trg_avg)
		newItem6->setTextAlignment(Qt::AlignHCenter);
		ui.tabWidget_stats->setItem(i, 6, newItem6);
		text = "-";
		if (!mWaveDump->IsManualOfflineEnabled())
			text = QString::number(b_avg, 'f', 3);
		QTableWidgetItem *newItem7 = new QTableWidgetItem(text); //QString("%1").arg(b_avg)
		newItem7->setTextAlignment(Qt::AlignHCenter);
		ui.tabWidget_stats->setItem(i, 7, newItem7);		
	}

	ui.lineEdit_run->setText(QString("%1").arg(mWaveDump->RunID));
	ui.lineEdit_global_evts->setText(QString("%1").arg(stats->getGlobalEvCnt()));
	ui.lineEdit_out_of_sync->setText(QString("%1").arg(stats->getOutOfSyncEvCnt()));
	double bb = static_cast<double>(stats->getTotBytesCnt());
	ui.lineEdit_tot_bytes->setText(QString::number((bb/1048576.),'f',2));
	mLastUpdateTime = currentTime;
	
}

void statisticsPanel::showData(QVector<int> counts, QVector<double> rates) {

	for (int i = 0; i < counts.size(); i++) {
		QTableWidgetItem *newItem2 = new QTableWidgetItem(QString("%1").arg(counts.at(i)));
		newItem2->setTextAlignment(Qt::AlignHCenter);
		ui.tabWidget_stats->setItem(i, 1, newItem2);
		QTableWidgetItem *newItem3 = new QTableWidgetItem(QString("%1").arg(rates.at(i)));
		newItem3->setTextAlignment(Qt::AlignHCenter);
		ui.tabWidget_stats->setItem(i, 2, newItem3);
	}
	ui.lineEdit_run->setText(QString("%1").arg(mWaveDump->RunID));
}

statisticsPanel::~statisticsPanel()
{
}
