/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		outputSettingsDialog.cpp
*	\brief
*	\author
*
******************************************************************************/

#include "outputSettingsDialog.h"
#include "WaveDump2.h"


outputSettingsDialog::outputSettingsDialog(WaveDump2 *parent) :
	QDialog(parent),
	ui(new Ui::outputSettingsDialog) {

	QString value;

	ui->setupUi(this);
	//ui->groupBox_2->setStyleSheet("border: 0px solid gray;");
	ui->groupBox->setStyleSheet("border: 0px solid gray;");
	ui->groupBox_3->setStyleSheet("border: 0px solid gray;");
	mWaveDump = parent;
	
	value = mWaveDump->getConfigValue("OUTPUT", "folder");
	if (value == "") value = QDir::homePath();
	ui->leFolder->setText(value);

	value = mWaveDump->getConfigValue("OUTPUT", "prefix");
	if (value == "") value = "Acq";
	ui->lePrefix->setText(value);

	value = mWaveDump->getConfigValue("OUTPUT", "ftype");
	if (value == "") value = "SINGLE";
	if (value.toUpper() == "SINGLE") ui->rbSingle->setChecked(true); else ui->rbMultiple->setChecked(true);

	value = mWaveDump->getConfigValue("OUTPUT", "header");
	if (value == "") value = "YES";
	if (value.toUpper() == "YES") ui->rbYes->setChecked(true); else ui->rbNo->setChecked(true);

	value = mWaveDump->getConfigValue("OUTPUT", "format");
	if (value == "") value = "ASCII";
	if (value.toUpper() == "ASCII") ui->rbAscii->setChecked(true); else ui->rbBinary->setChecked(true);
	if (mWaveDump->getGlobalSMode() != "SW_ASYNC") {
		ui->checkBox_sync->setEnabled(true);
		value = mWaveDump->getConfigValue("OUTPUT", "sync");
		if (value == "") value = "YES";
		if (value.toUpper() == "YES") {
			ui->checkBox_sync->setChecked(true);
			ui->rbSingle->setChecked(true);
			ui->groupBox_4->setEnabled(false);
		}
		else 
			ui->checkBox_sync->setChecked(false);

		connect(ui->checkBox_sync, SIGNAL(stateChanged(int)), this, SLOT(SingleSyncEnable(int)));
	}
	else {
		ui->checkBox_sync->setEnabled(false);
		ui->checkBox_sync->setChecked(false);
	}

	value = mWaveDump->getConfigValue("OUTPUT", "nevts");
	int n = value.toInt();
	if (n) {
		ui->groupBox_file_size->setChecked(true);
		ui->spinBox_nevts_file->setValue(n);
	}
	else {
		ui->groupBox_file_size->setChecked(false);
		ui->spinBox_nevts_file->setValue(0);
	}

	if (mWaveDump->IsFastSaveEnabled()) {
		ui->groupBox_4->setEnabled(false);
		ui->groupBox_3->setEnabled(false);
		ui->groupBox->setEnabled(false);
		ui->groupBox_file_size->setEnabled(false);
		ui->checkBox_sync->setEnabled(false);
		ui->checkBox_save_fast->setChecked(true);
	}

	if (mWaveDump->OfflineMode)
		ui->checkBox_save_fast->setEnabled(false);

	connect(this->ui->pbBrowse, SIGNAL(clicked()), this, SLOT(editFolder()));
	connect(this->ui->lePrefix, SIGNAL(textChanged(QString)), this, SLOT(prefixChanged(QString)));
	connect(this->ui->rbAscii, SIGNAL(clicked()), this, SLOT(editingFinished()));
	connect(this->ui->rbBinary, SIGNAL(clicked()), this, SLOT(editingFinished()));
	connect(this->ui->rbMultiple, SIGNAL(clicked()), this, SLOT(editingFinished()));
	connect(this->ui->rbSingle, SIGNAL(clicked()), this, SLOT(editingFinished()));
	connect(this->ui->rbYes, SIGNAL(clicked()), this, SLOT(editingFinished()));
	connect(this->ui->rbNo, SIGNAL(clicked()), this, SLOT(editingFinished()));
	connect(this->ui->okButton, SIGNAL(clicked()), this, SLOT(saveSettings()));
	connect(this->ui->groupBox_file_size, SIGNAL(clicked(bool)), this, SLOT(FileSizeChanged(bool)));
	connect(ui->checkBox_save_fast, SIGNAL(stateChanged(int)), this, SLOT(SaveFastEnable(int)));

	editingFinished();//update info lineedit
}

outputSettingsDialog::~outputSettingsDialog()
{
	delete ui;
}

void outputSettingsDialog::editFolder() {
	QString dir = QFileDialog::getExistingDirectory(this, tr("Open Directory"), ui->leFolder->text(), QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks);
	if (dir != "") ui->leFolder->setText(dir);
}

void outputSettingsDialog::saveSettings() {
	mWaveDump->setOutputSettings(this->ui->leFolder->text(), 
								this->ui->lePrefix->text(), 
								(ui->rbSingle->isChecked()) ? "SINGLE" : "MULTIPLE",
								(ui->rbYes->isChecked()) ? "YES" : "NO",
								(ui->rbAscii->isChecked()) ? "ASCII" : "BINARY",
								(ui->checkBox_sync->isChecked()) ? "YES" : "NO",
								ui->spinBox_nevts_file->value(),
								true);
	mWaveDump->enableFastSave((ui->checkBox_save_fast->isChecked()) ? true : false);
	if (ui->checkBox_save_fast->isChecked())
		mWaveDump->enableDataSave(true);
}

void outputSettingsDialog::prefixChanged(QString s) {
	Q_UNUSED(s);
	editingFinished();
}

void outputSettingsDialog::editingFinished() {
	QString txt = "(i.e. ";
	txt += this->ui->lePrefix->text();
	if (ui->checkBox_sync->isChecked())
		txt += "_SYNC";
	else
		txt += "_[Device_name]";
	txt += "_[Datetime]";
	if (this->ui->rbMultiple->isChecked()) 
		txt += "_CHXX";
	txt += "-[RunId]";
	if (ui->checkBox_save_fast->isChecked())
		txt += ".wbin";
	else {
		if (this->ui->rbAscii->isChecked())
			txt += ".txt)";
		else txt += ".bin)";
	}
	this->ui->lExample->setText(txt);
}

void  outputSettingsDialog::SingleSyncEnable(int enable) {
	if (enable) {
		ui->rbSingle->setChecked(true);
		ui->rbMultiple->setEnabled(false);
		ui->groupBox_4->setEnabled(false);
	}
	else {
		ui->rbMultiple->setEnabled(true);
		ui->groupBox_4->setEnabled(true);
	}
	editingFinished();
}

void outputSettingsDialog::FileSizeChanged(bool active) {
	if (active) {
		ui->spinBox_nevts_file->blockSignals(true);
		ui->spinBox_nevts_file->setValue(1);
		ui->spinBox_nevts_file->blockSignals(false);
	}
	else {
		ui->spinBox_nevts_file->blockSignals(true);
		ui->spinBox_nevts_file->setValue(0);
		ui->spinBox_nevts_file->blockSignals(false);
	}
}

void  outputSettingsDialog::SaveFastEnable(int enable) {
	if (enable) {
		ui->rbSingle->setChecked(true);
		ui->rbMultiple->setEnabled(false);
		ui->groupBox_4->setEnabled(false);
		ui->groupBox_3->setEnabled(false);
		ui->groupBox->setEnabled(false);
		ui->groupBox_file_size->setEnabled(false);
		ui->checkBox_sync->setEnabled(false);
		QMessageBox::warning(this, tr("Warning"), "Fast save mode selected. Data plot will be disabled and raw data will be saved for offline analysis.\n");
	}
	else {
		ui->rbMultiple->setEnabled(true);
		ui->groupBox_4->setEnabled(true);
		ui->groupBox_3->setEnabled(true);
		ui->groupBox->setEnabled(true);
		ui->groupBox_file_size->setEnabled(true);
		ui->checkBox_sync->setEnabled(true);
	}
	editingFinished();
}