/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		openDialog.cpp
*	\brief
*	\author
*
******************************************************************************/

#include "openDialog.h"

#include <QtWidgets>

#include "WaveDump2.h"

openDialog::openDialog(WaveDump2 *parent)
	: QDialog(parent)
	, ui(new Ui::openDialog)
	, mWaveDump(parent)
{
	ui->setupUi(this);
	showProgress(false);
#ifdef WIN32
	mIniFile = QString(qgetenv("USERPROFILE") + QString("/.WaveDump2.ini"));
#else
	mIniFile = QString(qgetenv("HOME") + QString("/.WaveDump.ini"));
#endif
	QSettings settings(mIniFile, QSettings::IniFormat);
	settings.beginGroup("Connection");
	mIpList << settings.value("IP_ADDRESS0", "").toString();
	mIpList << settings.value("IP_ADDRESS1", "").toString();
	mIpList << settings.value("IP_ADDRESS2", "").toString();
	mIpList << settings.value("IP_ADDRESS3", "").toString();
	mIpList << settings.value("IP_ADDRESS4", "").toString();
	mNameList << settings.value("NAME0", "").toString();
	mNameList << settings.value("NAME1", "").toString();
	mNameList << settings.value("NAME2", "").toString();
	mNameList << settings.value("NAME3", "").toString();
	mNameList << settings.value("NAME4", "").toString();
	settings.endGroup();
	mCompleterIp = new QCompleter(mIpList, this);
	mCompleterIp->setCaseSensitivity(Qt::CaseInsensitive);
	ui->le_address->setCompleter(mCompleterIp);
	mCompleterName = new QCompleter(mNameList, this);
	mCompleterName->setCaseSensitivity(Qt::CaseInsensitive);
	ui->leName->setCompleter(mCompleterName);
	ui->pB_reconnect->setAutoDefault(false);
	ui->connectButton->setAutoDefault(true);

	const QIcon connectIcon = QIcon(":Connect.png");
	this->setWindowIcon(connectIcon);
	connect(ui->connectButton, SIGNAL(clicked()), this, SLOT(OkButtonClick()));
	connect(ui->cancelButton, SIGNAL(clicked()), this, SLOT(CancelButtonClick()));
	connect(ui->pB_reconnect, SIGNAL(clicked()), this, SLOT(ReconnectButtonClick()));
	connect(ui->cb_ConnType, SIGNAL(currentIndexChanged(int)), this, SLOT(ConnTypeChanged(int)));
	connect(ui->cb_ConnType_dig1, SIGNAL(currentIndexChanged(int)), this, SLOT(ConnTypeChanged_1(int)));

}

openDialog::~openDialog()
{
	delete ui;
	delete mCompleterIp;
	delete mCompleterName;
}

void openDialog::OkButtonClick() {
	uint64_t res;
	if (mConnecting) {
		this->reject();
		return;
	}
	showProgress(true);
	mConnecting = true;
	//this->hide();
	if(ui->tabWidget->currentWidget() == ui->tab_dig2)
		res = mWaveDump->openDeviceExec(ui->cb_ConnType->currentIndex(), ui->le_address->text(), ui->leName->text(), true);
	else {
		QString path = getDig1ConnectionPath();
		res = mWaveDump->openDeviceExec(ui->cb_ConnType_dig1->currentIndex() + 100, path, ui->leName_1->text(), true);
	}
	if (res == 0xFFFFFFFFFFFFFFFF) {
		showProgress(false);
		mConnecting = false;
		return;
	}
	mWaveDump->CheckConnectedDevStatus();
	this->close();
}

void openDialog::CancelButtonClick() {
	this->reject();
	if (mConnecting) {
		mWaveDump->abortConnection();
		mConnecting = false;
	}
}

void openDialog::ReconnectButtonClick() {
	uint64_t res;
	if (mConnecting) {
		this->reject();
		return;
	}
	showProgress(true);
	mConnecting = true;
	res = mWaveDump->ReConnect();
	if (res == 0xFFFFFFFFFFFFFFFF) {
		showProgress(false);
		mConnecting = false;
		return;
	}
	mWaveDump->CheckConnectedDevStatus();
	this->close();
}

void openDialog::ConnTypeChanged(int ctype) {
	if (ctype == CONN_TYPE_ETH)
		ui->label_2->setText("IP Address");
	else
		ui->label_2->setText("PID");

}

void openDialog::ConnTypeChanged_1(int ctype) {
	ui->lineEdit_link_num->setText("");
	ui->lineEdit_conet_node->setText("");
	ui->lineEdit_vme_ba->setText("");
	if (ctype == CONN_TYPE_USB_1) {
		ui->lineEdit_link_num->setEnabled(true);
		ui->lineEdit_link_num->setText("0");
		ui->lineEdit_conet_node->setEnabled(false);
		ui->lineEdit_vme_ba->setEnabled(true);
		ui->lineEdit_vme_ba->setText("00000000");
		ui->label_5->setText("Link Number");
	}
	else if(ctype == CONN_TYPE_USB_A4818 || ctype == CONN_TYPE_USB_V4718) {
		ui->lineEdit_link_num->setEnabled(true);
		ui->lineEdit_link_num->setText("0");
		ui->label_5->setText("PID");
		ui->lineEdit_conet_node->setEnabled(true);
		ui->lineEdit_conet_node->setText("0");
		ui->lineEdit_vme_ba->setEnabled(true);
		ui->lineEdit_vme_ba->setText("00000000");
	}
	else if (ctype == CONN_TYPE_OPTILINK) {
		ui->lineEdit_link_num->setEnabled(true);
		ui->lineEdit_link_num->setText("0");
		ui->label_5->setText("Link Number");
		ui->lineEdit_conet_node->setEnabled(true);
		ui->lineEdit_conet_node->setText("0");
		ui->lineEdit_vme_ba->setEnabled(true);
		ui->lineEdit_vme_ba->setText("00000000");
	}
	else if (ctype == CONN_TYPE_ETH_V4718) {
		ui->lineEdit_link_num->setEnabled(true);
		ui->lineEdit_link_num->setText("0");
		ui->label_5->setText("IP Address");
		ui->lineEdit_conet_node->setEnabled(false);
		ui->lineEdit_vme_ba->setEnabled(true);
		ui->lineEdit_vme_ba->setText("00000000");
	}

}

QString openDialog::getDig1ConnectionPath() {//TODO: check all the connection options
	int index = ui->cb_ConnType_dig1->currentIndex();
	QString path = "caen.internal";
	switch (index) {
		case CONN_TYPE_USB_1:
			path.append("/usb");
			if(!ui->lineEdit_link_num->text().isEmpty())
				path.append("?link_num=" + ui->lineEdit_link_num->text());
			if (!ui->lineEdit_vme_ba->text().isEmpty() && ui->lineEdit_vme_ba->text() != "00000000")
				path.append("&vme_base_address=0x" + ui->lineEdit_vme_ba->text());
			if (ui->lineEdit_link_num->text().isEmpty())
				path.replace('&','?');
			break;
		case CONN_TYPE_USB_A4818:
			path.append("/usb_a4818?link_num=" + ui->lineEdit_link_num->text()); //link num is A4818 PID
			if (!ui->lineEdit_conet_node->text().isEmpty())
				path.append("&conet_node=" + ui->lineEdit_conet_node->text());
			if (!ui->lineEdit_vme_ba->text().isEmpty() && ui->lineEdit_vme_ba->text() != "00000000")
				path.append("&vme_base_address=0x" + ui->lineEdit_vme_ba->text());
			break;
		case CONN_TYPE_USB_V4718:
			path.append("/usb_v4718?link_num=" + ui->lineEdit_link_num->text()); //link num is V4718 PID
			if (!ui->lineEdit_vme_ba->text().isEmpty() && ui->lineEdit_vme_ba->text() != "00000000")
				path.append("&vme_base_address=0x" + ui->lineEdit_vme_ba->text());
			break;
		case CONN_TYPE_OPTILINK:
			path.append("/optical_link");
			if (!ui->lineEdit_link_num->text().isEmpty())
				path.append("?link_num=" + ui->lineEdit_link_num->text());
			if (!ui->lineEdit_conet_node->text().isEmpty())
				path.append("&conet_node=" + ui->lineEdit_conet_node->text());
			if (!ui->lineEdit_vme_ba->text().isEmpty() && ui->lineEdit_vme_ba->text() != "00000000")
				path.append("&vme_base_address=0x" + ui->lineEdit_vme_ba->text());
			if (ui->lineEdit_link_num->text().isEmpty())
				path.replace('&', '?');
			break;
		case CONN_TYPE_ETH_V4718:
			path = ui->lineEdit_link_num->text();
			path.append("/eth_v4718");
			if (!ui->lineEdit_vme_ba->text().isEmpty() && ui->lineEdit_vme_ba->text() != "00000000")
				path.append("?vme_base_address=0x" + ui->lineEdit_vme_ba->text());
			break;

	}
	return path;
}
	
void openDialog::showProgress(bool flag) {
	this->ui->progressBar->setVisible(flag);
	this->ui->lProgressBar->setVisible(flag);
}

void openDialog::increaseProgressBar() {
	int v = ui->progressBar->value();
	if (v == ui->progressBar->maximum()) v = 0; else v+=5;
	ui->progressBar->setValue(v);
}
