/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		manualControllerPanel.cpp
*	\brief
*	\author
*
******************************************************************************/

#include "manualControllerPanel.h"
#include "ui_manualControllerPanel.h"

#include <CAEN_FELib.h>
#include <cstring>
#include "WaveDump2.h"

using namespace std;

manualControllerPanel::manualControllerPanel(WaveDump2 *parent) :
	QWidget(parent),
	ui(new Ui::manualControllerPanel),
	mRootHandle{}
{
	mWaveDump = parent;
	ui->setupUi(this);
	//ui->bPanel->setStyleSheet("background-color:white;");
	connect(this->ui->pbGetValue, SIGNAL(clicked()), this, SLOT(getValue()));
	connect(this->ui->pbSetValue, SIGNAL(clicked()), this, SLOT(setValue()));
	connect(this->ui->pBSendCmd, SIGNAL(clicked()), this, SLOT(sendCMD()));
	connect(this->ui->leQry, SIGNAL(cursorPositionChanged(int, int)), this, SLOT(enableValue()));
    connect(this->ui->cbDevice, SIGNAL(currentIndexChanged(int)), this, SLOT(resetFields(int)));
	connect(this->ui->leQry, SIGNAL(editingFinished()), this, SLOT(resetFields()));
	connect(this, SIGNAL(ManualExec()), parent, SLOT(CheckSettings()));
}

manualControllerPanel::~manualControllerPanel()
{
	delete ui;
}


void manualControllerPanel::enableValue() {
    this->ui->leValue->setEnabled(true);
    this->ui->leValueLabel->setEnabled(true);
    this->ui->cbValue->setEnabled(false);
    this->ui->cbValueLabel->setEnabled(false);
}

void manualControllerPanel::addDevice(const QString& name, std::uint64_t handle) {
	mDevices.insert(name, handle);
	this->ui->cbDevice->addItem(name);
}

void manualControllerPanel::removeDevice(const QString& name) {
	mDevices.remove(name);
	this->ui->cbDevice->removeItem(this->ui->cbDevice->findText(name));
}

void manualControllerPanel::showData(uint32_t handle, const QString& rootName, const QString& qry, bool isParam) {

	QStringList labels;
	CAEN_FELib_ErrorCode ret, ErrCode;
	char allowVal[32];
	uint64_t handles[32];

	mRootHandle = mDevices.value(rootName);
	this->ui->cbDevice->setCurrentText(rootName);
	this->ui->leQry->setText(qry);
	this->ui->leQry->setEnabled(true);
	if (isParam) {
		char value2[32];
		char accMode[32];

		ErrCode = (CAEN_FELib_ErrorCode)CAEN_FELib_GetValue(handle, "", value2);
		QString value(value2);
		this->ui->leValue->setText(value);
		ErrCode = (CAEN_FELib_ErrorCode)CAEN_FELib_GetValue(handle, "/accessMode", accMode);
		if (QString(accMode) == "READ_ONLY") {
			this->ui->pbSetValue->setEnabled(false);
			this->ui->leValue->setEnabled(false);
            this->ui->leValueLabel->setEnabled(false);
            this->ui->cbValue->setEnabled(false);
            this->ui->cbValueLabel->setEnabled(false);

		}
		else {
			this->ui->pbSetValue->setEnabled(true);
			this->ui->leValue->setEnabled(true);
            this->ui->leValueLabel->setEnabled(true);
            this->ui->cbValue->setEnabled(true);
            this->ui->cbValueLabel->setEnabled(true);
		}
		this->ui->pbGetValue->setEnabled(true);
		ErrCode = (CAEN_FELib_ErrorCode)CAEN_FELib_GetValue(handle, "/allowedValues", allowVal);
		if (ErrCode == CAEN_FELib_Success) {
			int v = QString(allowVal).toInt();
			ret = (CAEN_FELib_ErrorCode)CAEN_FELib_GetChildHandles(handle, "/allowedValues/", handles, 32);
			labels.clear();
			this->ui->cbValue->clear();
			for (int i = 0; i < ret; i++) {
				CAEN_FELib_NodeType_t type;
				std::memset(value2, 0, 32);
				ErrCode = (CAEN_FELib_ErrorCode)CAEN_FELib_GetNodeProperties(handles[i], "", value2, &type);
				if (ErrCode != CAEN_FELib_Success)
					break;
				labels.insert(i, QString(value2));
			}
			this->ui->cbValue->setCurrentText(value);
			this->ui->cbValue->addItems(labels);
            this->ui->leValue->setEnabled(false);
            this->ui->leValueLabel->setEnabled(false);
            this->ui->cbValue->setEnabled(true);
            this->ui->cbValueLabel->setEnabled(true);
		}
		else {
            this->ui->leValue->setEnabled(true);
            this->ui->leValueLabel->setEnabled(true);
            this->ui->cbValue->setEnabled(false);
            this->ui->cbValueLabel->setEnabled(false);
		}
	}
	else {
        this->ui->leValue->setEnabled(false);
        this->ui->cbValue->setEnabled(false);
        this->ui->leValueLabel->setEnabled(false);
        this->ui->pbGetValue->setEnabled(false);
	}

	if (qry.contains("CMD")) {
		this->ui->pbGetValue->setEnabled(false);
	}
	else {
		this->ui->pbGetValue->setEnabled(true);
	}
	this->ui->cbDevice->setEnabled(true);
}

void manualControllerPanel::disableAll() {
	this->ui->pbGetValue->setEnabled(false);
	this->ui->pbSetValue->setEnabled(false);
    this->ui->leValue->setEnabled(false);
    this->ui->cbValue->setEnabled(false);
    this->ui->leValueLabel->setEnabled(false);
    this->ui->pbGetValue->setEnabled(false);
	this->ui->leQry->setEnabled(false);
	this->ui->cbDevice->setEnabled(false);
}

void manualControllerPanel::getValue() {
	char value[256];

	QString qry = this->ui->leQry->text();
	CAEN_FELib_ErrorCode ErrCode = (CAEN_FELib_ErrorCode)CAEN_FELib_GetValue(mRootHandle, qPrintable(qry), value);
	if (ErrCode == CAEN_FELib_Success) {
		this->ui->leValue->setText(QString(value));
		this->ui->cbValue->setCurrentText(QString(value));
	}
	else
		mWaveDump->addLog("Get " + qry + QString("  error %1").arg(ErrCode), false);
}

void manualControllerPanel::setValue() {
	char value[32];

	const QString qry = this->ui->leQry->text();
    if (this->ui->leValue->isEnabled())
		qstrncpy(value, qPrintable(ui->leValue->text()), 32);
	else
		qstrncpy(value, qPrintable(ui->cbValue->currentText()), 32);
	CAEN_FELib_ErrorCode ErrCode = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mRootHandle, qPrintable(qry), value);
	if (ErrCode != CAEN_FELib_Success) 
		mWaveDump->addLog("Set " + qry + QString("  error %1").arg(ErrCode), false);
	mWaveDump->add2LogAndConf("SET", this->ui->cbDevice->currentText(), qry, QString(value), QString(value), ErrCode);
	emit ManualExec();
}

void manualControllerPanel::sendCMD() {
	char value[32] = "";

	const QString qry = this->ui->leQry->text();
	CAEN_FELib_ErrorCode ErrCode = (CAEN_FELib_ErrorCode)CAEN_FELib_SendCommand(mRootHandle, qPrintable(qry));
	mWaveDump->add2LogAndConf("CMD", this->ui->cbDevice->currentText(), qry, QString(value), QString(value), ErrCode);
}

void manualControllerPanel::resetFields(int index){
    Q_UNUSED(index)
    resetFields();
}


void manualControllerPanel::resetFields() {
	this->mRootHandle = mDevices.value(this->ui->cbDevice->currentText());
	this->ui->pbSetValue->setEnabled(true);
	this->ui->leValue->setEnabled(true);
    this->ui->leValueLabel->setEnabled(true);
    this->ui->cbValue->setEnabled(false);
    this->ui->cbValueLabel->setEnabled(false);
    this->ui->pbGetValue->setEnabled(false);
	if (this->ui->leQry->text().contains("CMD")) {
		this->ui->pbGetValue->setEnabled(false);
	}
	else {
		this->ui->pbGetValue->setEnabled(true);
	}
}
