/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		main.cpp
*	\brief
*	\author
*
******************************************************************************/

#include <QtWidgets/QApplication>

#include "WaveDump2.h"

int main(int argc, char *argv[]) {

	QApplication a(argc, argv);
	QApplication::setStyle(QStyleFactory::create("Fusion"));
	QString open_filename = "";
	if (argc>1) {
		open_filename = QString::fromUtf8(argv[1]);
	}
	WaveDump2 w;
	if (argc>1 && open_filename.endsWith(".wconf"))
		w.loadFile(open_filename, true);
	if (argc > 1 && open_filename.endsWith(".wsets")) {
		QMessageBox::information(0, "WaveDump2 Info", "<html><B>You are trying to open a script file (.wsets) with WaveDump2.\n Please connect at least one device before loading a .wsets file. </html>");
	}
	w.show();

	return a.exec();
}
