/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		logPanel.cpp
*	\brief
*	\author
*
******************************************************************************/

#include "logPanel.h"
#include "ui_logPanel.h"

#include <QString>

#include "WaveDump2.h"

logPanel::logPanel(QWidget *parent)
	: QWidget(parent)
	, ui(new Ui::logPanel)
{
	ui->setupUi(this);
	mToolBar = new QToolBar(this);

	QWidget *spacerWidget = new QWidget(this);
	spacerWidget->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Preferred);
	spacerWidget->setVisible(true);
	mToolBar->addWidget(spacerWidget);

	QString folder = QStandardPaths::writableLocation(QStandardPaths::AppDataLocation);
	QDir().mkdir(folder);
	mLogfile = new QFile(folder + "/WD2Log.txt");
	mLogfile->open(QIODevice::WriteOnly|QIODevice::Truncate);
	mout.setDevice(mLogfile);

	mlogTimer.start();
}

logPanel::~logPanel()
{
	mLogfile->close();
	delete ui;
}

void logPanel::add2Log(const QString& cmd, const QString& qry, const QString& val, const QString& name, CAEN_FELib_ErrorCode res) {
	const QString result = (res == CAEN_FELib_Success) ?
		"<font color=\"green\">SUCCESS</font>" :
		"<font color=\"red\">FAILED</font>";
	QString line, line1;
	if (cmd == "CMD") {
		line = "<HTML>Sent Command: <b>" + qry + "  [" + result + "]</HTML>";
		line1 = "[ " + elapsedTime_s() + " s]" + " Sent Command: " + qry + " to " + name;
	}
	else if (cmd == "SET") {
		line = "<HTML>" + cmd + ": <b>" + qry + "</b> to " + val + "  [" + result + "]</HTML>";
		line1 = "[ " + elapsedTime_s() + " s] " + name + " " + cmd + ": " + qry + " to " + val;
	}
	else if (cmd == "GET") {
		line = "<HTML>" + cmd + ": <b>" + qry + "</b> = " + val + "  [" + result + "]</HTML>";
		line1 = "[ " + elapsedTime_s() + " s] " + name + " " + cmd + ": " + qry + " = " + val;
	}

	this->ui->teLog->append(line);
	if (res == CAEN_FELib_Success) {
		//save in temp confi file...
		mout << line1 << ENDL;
		mout.flush();
	}
}

void logPanel::add2Log(const QString& sentence, bool res) {
	const QString result = res ? "<font color=\"green\">SUCCESS</font>" : "<font color=\"red\">FAILED</font>";
	const QString line = "<HTML><b>" + sentence + "  [" + result + "]</HTML>";
	this->ui->teLog->append(line);
	mout << "[ " << elapsedTime_s() << " s] ";
	mout << sentence << ENDL;
	mout.flush();
}
