/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		discoveryDevicesDialog.cpp
*	\brief
*	\author
*
******************************************************************************/

#include "discoveryDevicesDialog.h"

#include <QtWidgets>

#include <CAEN_FELib.h>

#include "WaveDump2.h"
#ifndef WIN32
#include <unistd.h>
#endif

discoveryDevicesDialog::discoveryDevicesDialog(WaveDump2 *parent)
	: QDialog(parent)
	, ui(new Ui::discoveryDevicesDialog)
	, mWaveDump(parent)
{
	ui->setupUi(this);
	const QIcon connectIcon = QIcon(":scan.png");
	this->setWindowIcon(connectIcon);
	this->setFixedSize(this->width(), this->height());
	mMainProgressBar = new QProgressBar(this);
	mMainProgressBar->setTextVisible(false);
	mMainProgressBar->setMaximum(100);
	mMainProgressBar->setMinimum(0);
	mMainProgressBar->setStyleSheet("text-align: center");
	mMainProgressBar->setFormat("Scanning devices");
	mMainProgressBar->setValue(0);
	mMainProgressBar->setLayoutDirection(Qt::LeftToRight);
	ui->verticalLayout->addWidget(mMainProgressBar);
	ui->twDevices->verticalHeader()->setVisible(false);
	ui->twDevices->horizontalHeader()->setStyleSheet("QHeaderView { font-weight: bold; }");
	ui->twDevices->setColumnWidth(1, 70);
	ui->twDevices->setColumnWidth(2, 75);
	ui->twDevices->setColumnWidth(3, 145);
	ui->twDevices->setSelectionBehavior(QTableView::SelectRows);
	ui->twDevices->horizontalHeader()->setSectionResizeMode(QHeaderView::Fixed);
	mTimer = new QTimer(this);
	connect(mTimer, SIGNAL(timeout()), this, SLOT(update()));
	connect(ui->pbStart, SIGNAL(clicked()), this, SLOT(start()));
	connect(ui->twDevices, SIGNAL(doubleClicked(QModelIndex const&)), this, SLOT(addDevice(QModelIndex const&)));
}

discoveryDevicesDialog::~discoveryDevicesDialog()
{
	delete ui;
}

void discoveryDevicesDialog::update() {
	int v = mMainProgressBar->value();
	if (v >= mMainProgressBar->maximum() - 1) {
		if (mL2r) {
			mMainProgressBar->setLayoutDirection(Qt::RightToLeft);
		}
		else {
			mMainProgressBar->setLayoutDirection(Qt::LeftToRight);
		}
		mL2r = !mL2r;
		v = 0;
	}
	else v += 5;
	mMainProgressBar->setValue(v);
}

void discoveryDevicesDialog::start() {
	int tm;

	mMainProgressBar->setTextVisible(true);
	mTimer->start(50);
	switch (ui->cbTimeout->currentIndex()) {
	case 0: 
		tm = 5;
		break;
	case 1:
		tm = 10;
		break;
	case 2:
		tm = 15;
		break;
	case 3:
		tm = 20;
		break;
	case 4:
		tm = 30;
		break;
	}
	mAsyncScan = QtConcurrent::run([this, tm] { return scan(tm); });
	while (mAsyncScan.isRunning()) {
#ifdef WIN32
                Sleep(30);
#else
                usleep(30000);
#endif
		QCoreApplication::processEvents();
	}
	QString result = mAsyncScan.result();
	mMainProgressBar->setTextVisible(false);
	mMainProgressBar->setValue(0);
	mTimer->stop();

	
	QJsonDocument d = QJsonDocument::fromJson(result.toUtf8());
	QJsonArray ja = d.array();
	for (int npcIndex = 0; npcIndex < ja.size(); ++npcIndex) {
		ui->twDevices->insertRow(ui->twDevices->rowCount());
		QJsonObject npcObject = ja[npcIndex].toObject();
		QString value = npcObject.value("model").toString();
		QTableWidgetItem *poItem = new QTableWidgetItem();
		poItem->setFlags(poItem->flags() & ~Qt::ItemIsEditable);
		poItem->setData(Qt::DisplayRole, QVariant(value));
		ui->twDevices->setItem(npcIndex, 0, poItem);
		value = npcObject.value("sernum").toString();
		poItem = new QTableWidgetItem();
		poItem->setFlags(poItem->flags() & ~Qt::ItemIsEditable);
		poItem->setTextAlignment(Qt::AlignCenter);
		poItem->setData(Qt::DisplayRole, QVariant(value));
		ui->twDevices->setItem(npcIndex, 1, poItem);
		QString type = npcObject.value("type").toString();
		poItem = new QTableWidgetItem();
		poItem->setFlags(poItem->flags() & ~Qt::ItemIsEditable);
		poItem->setTextAlignment(Qt::AlignCenter);
		poItem->setData(Qt::DisplayRole, QVariant(type));
		ui->twDevices->setItem(npcIndex, 2, poItem);
		value = npcObject.value("ipaddress").toString();
		poItem = new QTableWidgetItem();
		poItem->setFlags(poItem->flags() & ~Qt::ItemIsEditable);
		poItem->setData(Qt::DisplayRole, QVariant(value));
		if (type != "usb")
			ui->twDevices->setItem(npcIndex, 3, poItem);
	}

}

QString discoveryDevicesDialog::scan(int timeout) {
	
	CAEN_FELib_ErrorCode ret;
	char jSonString[1024];
	ret = (CAEN_FELib_ErrorCode)CAEN_FELib_DevicesDiscovery(jSonString, 1024, timeout);
	QString val(jSonString);
	/*QFile file;
	file.setFileName("DiscoveryExample.json");
	file.open(QIODevice::ReadOnly | QIODevice::Text);
	val = file.readAll();
	file.close();
	QThread::sleep(timeout);*/
	return val;
}

void discoveryDevicesDialog::addDevice(QModelIndex const &index) {
	mName = ui->twDevices->item(index.row(), 0)->text();
	mSerNum = ui->twDevices->item(index.row(), 1)->text();
	mType = ui->twDevices->item(index.row(), 2)->text();
	mAddress = ui->twDevices->item(index.row(), 3)->text();
	this->hide();
}

const QString& discoveryDevicesDialog::getAddress() const {
	return this->mAddress;
}

int discoveryDevicesDialog::getType() const {
	return (this->mType == "usb") ? 1 : 0;
}
