/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		deviceManagerPanel.cpp
*	\brief
*	\author
*
******************************************************************************/

#include "deviceManagerPanel.h"
#include "ui_deviceManagerPanel.h"

#include <QMessageBox>

#include <CAEN_FELib.h>

#include "CAENTreeWidgetItem.h"
#include "WaveDump2.h"
#include <cstring>

 using namespace std;


deviceManagerPanel::deviceManagerPanel(WaveDump2 *parent)
	: QWidget(parent)
	, ui(new Ui::deviceManagerPanel)
	, mWaveDump(parent)
	, mLabel(9)
	, mPtValue(9)
{
	ui->setupUi(this);
	connect(ui->deviceManagerTreeWidget, SIGNAL(itemClickedSignal(CAENTreeWidgetItem*, int)),this, SLOT(itemClicked2(CAENTreeWidgetItem*, int)));
	connect(ui->deviceManagerTreeWidget, SIGNAL(manualPClickedSignal(CAENTreeWidget*)), this, SLOT(manualParamClicked(CAENTreeWidget*)));
    connect(ui->deviceManagerTreeWidget, SIGNAL(manualCClickedSignal(CAENTreeWidget*)), this, SLOT(manualCommandClicked(CAENTreeWidget*)));
	connect(this, SIGNAL(SetValueManual()), parent, SLOT(CheckSettings()));
	createPropertyWidget();
}

deviceManagerPanel::~deviceManagerPanel()
{
	delete ui;
}


void deviceManagerPanel::createPropertyWidget() {
	QFont BolfFont;

	BolfFont.setBold(true);
	ui->AttributesTreeWidget->setRootIsDecorated(true);
	ui->AttributesTreeWidget->setIndentation(10);
	ui->AttributesTreeWidget->header()->setSectionResizeMode(QHeaderView::ResizeMode::ResizeToContents);
	ui->AttributesTreeWidget->header()->setStretchLastSection(true);

	QTreeWidgetItem* pProperty = new QTreeWidgetItem();
	pProperty->setBackground(0, QColor(0xDA, 0xDA, 0xDA, 0xFF));


	ui->AttributesTreeWidget->addTopLevelItem(pProperty);
	ui->AttributesTreeWidget->setHeaderHidden(true);
	ui->AttributesTreeWidget->setMaximumHeight(320);

	pProperty->setText(0, "Property");
	pProperty->setFont(0, BolfFont);

	mTableWidget = new QTableWidget(9, 2, this);
	mTableWidget->setMinimumHeight(210);
	mTableWidget->setMaximumHeight(210);
	mTableWidget->horizontalHeader()->hide();
	mTableWidget->verticalHeader()->hide();
	mTableWidget->setAlternatingRowColors(true);
	mTableWidget->setStyleSheet("alternate-background-color: #FAFAFA;background-color: #F0F0F0;");

	mLabel[0] = new QTableWidgetItem("Handle", 0);
	mLabel[0]->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled);
	mTableWidget->setItem(0, 0, mLabel[0]);

	mLabel[1] = new QTableWidgetItem("QryString", 0);
	mLabel[1]->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled);
	mTableWidget->setItem(1, 0, mLabel[1]);

	mLabel[2] = new QTableWidgetItem("Value", 0);
	mLabel[2]->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled);
	mTableWidget->setItem(2, 0, mLabel[2]);

	mLabel[3] = new QTableWidgetItem("UoM", 0);
	mLabel[3]->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled);
	mTableWidget->setItem(3, 0, mLabel[3]);

	mLabel[4] = new QTableWidgetItem("Minimum", 0);
	mLabel[4]->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled);
	mTableWidget->setItem(4, 0, mLabel[4]);

	mLabel[5] = new QTableWidgetItem("Maximum", 0);
	mLabel[5]->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled);
	mTableWidget->setItem(5, 0, mLabel[5]);

	mLabel[6] = new QTableWidgetItem("Increment", 0);
	mLabel[6]->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled);
	mTableWidget->setItem(6, 0, mLabel[6]);

	mLabel[7] = new QTableWidgetItem("AccessMode", 0);
	mLabel[7]->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled);
	mTableWidget->setItem(7, 0, mLabel[7]);

	mLabel[8] = new QTableWidgetItem("SetInRun", 0);
	mLabel[8]->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled);
	mTableWidget->setItem(8, 0, mLabel[8]);

	for (int i = 0; i < 9; i++) {
		mPtValue[i] = new QTableWidgetItem("", 0);
		mPtValue[i]->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled);
		mTableWidget->setItem(i, 1, mPtValue[i]);
	}
	
	QItemDelegate *itemDelegate = new QItemDelegate(mTableWidget);
	connect(itemDelegate, SIGNAL(closeEditor(QWidget*)), this, SLOT(setValue()));
	mTableWidget->setItemDelegateForColumn(1, itemDelegate);

	
	mTableWidget->horizontalHeader()->setStretchLastSection(true);
	mTableWidget->setFrameStyle(QFrame::NoFrame);

	QHeaderView *verticalHeader = mTableWidget->verticalHeader();
	verticalHeader->setSectionResizeMode(QHeaderView::Fixed);
	verticalHeader->setDefaultSectionSize(20);
	QTreeWidgetItem* pContainerProp = new QTreeWidgetItem();
	pContainerProp->setDisabled(true);

	pProperty->addChild(pContainerProp);
	ui->AttributesTreeWidget->setItemWidget(pContainerProp, 0, mTableWidget);

	QTreeWidgetItem* pDescription = new QTreeWidgetItem();
	pDescription->setBackground(0, QColor(0xDA, 0xDA, 0xDA, 0xFF));
	ui->AttributesTreeWidget->addTopLevelItem(pDescription);
	ui->AttributesTreeWidget->setHeaderHidden(true);
	pDescription->setText(0, "Description");
	pDescription->setFont(0, BolfFont);

	mPropertyDescription = new QTextEdit(this);
	QTreeWidgetItem* pContainerDesc = new QTreeWidgetItem();
	mPropertyDescription->setFrameStyle(QFrame::NoFrame);
	pContainerDesc->setDisabled(true);
	mPropertyDescription->setText("");
	mPropertyDescription->setMaximumHeight(70);
	pDescription->addChild(pContainerDesc);
	ui->AttributesTreeWidget->setItemWidget(pContainerDesc, 0, mPropertyDescription);
	pProperty->setExpanded(true);
	pDescription->setExpanded(true);
}

QString deviceManagerPanel::convertUoM(const char *uom, const char* exp) {
	int ex = QString(exp).toInt();
	QString sEx;
	switch (ex) {
	case -9:
		sEx = "NANO";
		break;
	case -6:
		sEx = "MICRO";
		break;
	case -3:
		sEx = "MILLI";
		break;
	case 1:
		sEx = "";
		break;
	case 3:
		sEx = "KILO";
		break;
	case 6:
		sEx = "MEGA";
		break;
	default:
		sEx = "";
		break;
	}
	return sEx + QString(uom).toUpper();
}

void deviceManagerPanel::removeDevice(std::uint64_t rootHandle) {
	// mRootHandle servir� quando avremo pi� device...
	if (!mRootTreeItem) {
		ui->deviceManagerTreeWidget->removeItemWidget(mRootTreeItem, 0);
		delete mRootTreeItem;
		ui->deviceManagerTreeWidget->clear();
	}
}

CAENTreeWidgetItem *deviceManagerPanel::addTreeRoot(const QString& name, int type, std::uint64_t handle)
{
	mRootTreeItem = new CAENTreeWidgetItem(type);
	mRootHandle = handle;
	mRootTreeItem->setText(0, name);
	mRootTreeItem->setRootName(name);
	mRootTreeItem->setHandle(handle);
	mRootTreeItem->setType((CAEN_FELib_NodeType_t) type);
	mRootTreeItem->setQry("/");
	ui->deviceManagerTreeWidget->addTopLevelItem(mRootTreeItem);
	return mRootTreeItem;
}

void deviceManagerPanel::itemClicked2(CAENTreeWidgetItem *itm, int col) {
	Q_UNUSED(col);
	std::uint64_t handle;
	std::uint64_t handles[32];
	CAEN_FELib_ErrorCode ret, ret1, ErrCode;
	QString str;
	char value[256];
	char accMode[32];
	char value2[256];
	char value3[32];
	char allowVal[32];

	handle = itm->getHandle();
	
	switch (itm->getType()) {
	case CAEN_FELib_NodeType_t::CAEN_FELib_COMMAND:
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_GetValue(handle, "/description", value);
		if (ret != CAEN_FELib_Success)
			break;
		str = QString(value);
		mPropertyDescription->setText(str);
		mPtValue[0]->setText("0x" + QString::number(itm->getHandle(), 16).rightJustified(16, '0').toUpper());
		mPtValue[1]->setText(itm->getQry());

		mCmdExe = new QPushButton("Execute", this);
		mCmdExe->setStyleSheet("QPushButton{font-weight: bold;}");
		mTableWidget->setCellWidget(2, 1, mCmdExe);
		mPtValue[3]->setText("");
		mPtValue[4]->setText("");
		mPtValue[5]->setText("");
		mPtValue[6]->setText("");
		mPtValue[7]->setText("");

		connect(mCmdExe, SIGNAL(clicked()), this, SLOT(sendCMD()));

		break;
	case CAEN_FELib_NodeType_t::CAEN_FELib_ENDPOINT:
	{
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_GetValue(handle, "/description", value);
		if (ret != CAEN_FELib_Success)
			break;
		str = QString(value);
		mPropertyDescription->setText(str);
		mPtValue[1]->setText(itm->getQry());
		mTableWidget->removeCellWidget(2, 1);
		mPtValue[0]->setText("0x" + QString::number(itm->getHandle(), 16).rightJustified(16, '0').toUpper());
		mPtValue[2]->setText("");
		mPtValue[3]->setText("");
		mPtValue[4]->setText("");
		mPtValue[5]->setText("");
		mPtValue[6]->setText("");
		mPtValue[7]->setText("READ_ONLY");
		break;
	}
	case CAEN_FELib_NodeType_t::CAEN_FELib_PARAMETER:
	case CAEN_FELib_NodeType_t::CAEN_FELib_FEATURE:
	{
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_GetValue(handle, "/datatype", value);

		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_GetValue(handle, "/description", value);
		if (ret != CAEN_FELib_Success)
			break;
		str = QString(value);
		mPropertyDescription->setText(str);
		mPtValue[0]->setText("0x" + QString::number(itm->getHandle(), 16).rightJustified(16, '0').toUpper());
		mPtValue[1]->setText(itm->getQry());
		ret1 = (CAEN_FELib_ErrorCode)CAEN_FELib_GetValue(handle, "/accessMode", accMode);
		if ((ret != CAEN_FELib_Success) || (ret1 != CAEN_FELib_Success))
			break;
		mPtValue[7]->setText(accMode);
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_GetValue(handle, "/allowedValues", allowVal);
		if (ret != CAEN_FELib_Success) {
			// it is not an enumerate
			ret1 = (CAEN_FELib_ErrorCode)CAEN_FELib_GetValue(handle, "/minValue", value2);
			if (ret1 != CAEN_FELib_Success)
				mPtValue[4]->setText("");
			else
				mPtValue[4]->setText(value2);
			ret1 = (CAEN_FELib_ErrorCode)CAEN_FELib_GetValue(handle, "/maxValue", value2);
			if (ret1 != CAEN_FELib_Success)
				mPtValue[5]->setText("");
			else
				mPtValue[5]->setText(value2);
			ret1 = (CAEN_FELib_ErrorCode)CAEN_FELib_GetValue(handle, "/increment", value2);
			if (ret1 != CAEN_FELib_Success)
				mPtValue[6]->setText("");
			else
				mPtValue[6]->setText(value2);
			ret = (CAEN_FELib_ErrorCode)CAEN_FELib_GetValue(handle, "", value);
			if (ret != CAEN_FELib_Success)
				mPtValue[2]->setText("");
			else
				mPtValue[2]->setText(value);
			ret = (CAEN_FELib_ErrorCode)CAEN_FELib_GetValue(handle, "/UOM", value2);
			ret1 = (CAEN_FELib_ErrorCode)CAEN_FELib_GetValue(handle, "/ExpUOM", value3);
			if ((ret != CAEN_FELib_Success) || (ret1 != CAEN_FELib_Success))
				mPtValue[3]->setText("");
			else
				mPtValue[3]->setText(convertUoM(value2, value3));
			if (strcmp(accMode, "READ_ONLY") == 0) {
				mPtValue[2]->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled);
			}
			else {
				mPtValue[2]->setFlags(Qt::ItemIsSelectable | Qt::ItemIsEnabled);
				mPtValue[2]->setFlags((Qt::ItemFlags)63);
			}
			mTableWidget->removeCellWidget(2, 1);
		}
		else {
			int v = atoi(allowVal); 
			ret = (CAEN_FELib_ErrorCode)CAEN_FELib_GetChildHandles(handle, "/allowedValues/", handles, 32);
			if (ret < CAEN_FELib_Success)
				break;
			mValues = new QComboBox(this);
			mValues->setStyleSheet("QComboBox{border: 0px solid gray;}");
			mValues->clear();
			for (int i = 0; i < ret; i++) {
				std::memset(value2, 0, 256);
				ErrCode = (CAEN_FELib_ErrorCode)CAEN_FELib_GetValue(handles[i], "", value2);
				if (ErrCode != CAEN_FELib_Success)
					break;
				mValues->addItem(QString(value2));
			}
			mPtValue[3]->setText("");
			mPtValue[4]->setText("");
			mPtValue[5]->setText("");
			mPtValue[6]->setText("");
			ret = (CAEN_FELib_ErrorCode)CAEN_FELib_GetValue(handle, "", value);
			if (ret != CAEN_FELib_Success)
				break;
			mValues->setCurrentText(value);
			mTableWidget->setCellWidget(2, 1, mValues);
			mValues->setVisible(true);

			connect(mValues, SIGNAL(currentIndexChanged(const QString&)), this, SLOT(setValue(const QString&)));
			
		}
		ret1 = (CAEN_FELib_ErrorCode)CAEN_FELib_GetValue(handle, "/setInRun", value2);
		if ((ret != CAEN_FELib_Success) || (ret1 != CAEN_FELib_Success))
			break;
		mPtValue[8]->setText(QString(value2).toUpper());
		break;
	}
	default: {
		mPtValue[0]->setText("");
		QString query = itm->getQry();
		mPtValue[1]->setText(query.replace("//", "/"));
		mPtValue[2]->setText("");
		mPtValue[3]->setText("");
		mPtValue[4]->setText("");
		mPtValue[5]->setText("");
		mPtValue[6]->setText("");
		mPtValue[7]->setText("READ_ONLY");
		mTableWidget->removeCellWidget(2, 1);
		break;
	}
	}
}

void deviceManagerPanel::setValue() {
	QString qry;
	CAEN_FELib_ErrorCode ErrCode;
	char value[32];

	qry = mPtValue[1]->text();
	qstrncpy(value, qPrintable(mPtValue[2]->text()), 32);
	ErrCode = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mRootHandle, qPrintable(qry), value);
	mWaveDump->add2LogAndConf("SET",mWaveDump->getCurrentDeviceName(), qry, QString(value), QString(value), ErrCode);
	emit SetValueManual();
}

void deviceManagerPanel::setValue(const QString &s) {
	QString qry;
	CAEN_FELib_ErrorCode ErrCode;
	char value[32];

	qry = mPtValue[1]->text();
	qstrncpy(value, qPrintable(s), 32);
	ErrCode = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mRootHandle, qPrintable(qry), value);
	mWaveDump->add2LogAndConf("SET", mWaveDump->getCurrentDeviceName(), qry, QString(value), QString(value), ErrCode);
	emit SetValueManual();
}

void deviceManagerPanel::sendCMD() {
	QString qry;
	CAEN_FELib_ErrorCode ErrCode;
	char value[32] = "";

	qry = mPtValue[1]->text();

	ErrCode = (CAEN_FELib_ErrorCode)CAEN_FELib_SendCommand(mRootHandle, qPrintable(qry));
	mWaveDump->add2LogAndConf("CMD", mWaveDump->getCurrentDeviceName(), qry, QString(value), QString(value), ErrCode);
	mCmdExe->setChecked(false);
}

void deviceManagerPanel::manualParamClicked(CAENTreeWidget *itm) {
	emit showManualController(itm->getItemHandle(), itm->getRootName(), itm->getQuery(), true);
}

void deviceManagerPanel::manualCommandClicked(CAENTreeWidget *itm) {
	emit showManualController(itm->getItemHandle(), itm->getRootName(), itm->getQuery(), false);
}
