/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		chmaskDialog.cpp
*	\brief
*	\author
*
******************************************************************************/

#include "chmaskDialog.h"
#include <QtGlobal>

chmaskDialog::chmaskDialog(QWidget *parent, int NCh, uint64_t current_mask)
	: QDialog(parent)
{
	ui.setupUi(this);
	setWindowTitle("Self Trigger Mask Setup");

	mMask = current_mask;
	mPbCh.resize(NCh);
	int checked = 0;
	ui.pushButton_all->setCheckable(true);
	for (int i = 0; i < NCh; i++) {
		mPbCh[i] = new QPushButton(this);
		mPbCh[i]->setProperty("index",i);
		mPbCh[i]->setMaximumWidth(17);
		mPbCh[i]->setMaximumHeight(17);
		mPbCh[i]->setText(QString::number(i));
		mPbCh[i]->setCheckable(true);
		mPbCh[i]->setFocusPolicy(Qt::NoFocus);
		mPbCh[i]->setStyleSheet("QPushButton{ background-color:rgb(156, 156, 156); }	QPushButton:checked{ background-color:rgb(49, 255, 159); }"	);
		if (mMask & (1LL << i)) {//i64
			mPbCh[i]->setChecked(true);
			checked++;
		}
		else
			mPbCh[i]->setChecked(false);
	}
	if (checked == NCh) {
		ui.pushButton_all->setChecked(true);
		ui.pushButton_all->setText("Deselect All");
	}

	if (NCh < 8) {
		for (int j = 0; j < NCh; j++)
			ui.lay_0->addWidget((mPbCh[j]));
	}
	else {
		for (int i = 0; i < (NCh / 8); i++) {
			for (int j = 0; j < 8; j++) {
				switch (i) {
				case 0:
					ui.lay_0->addWidget((mPbCh[(i * 8) + j]));
					break;
				case 1:
					ui.lay_1->addWidget(mPbCh[(i * 8) + j]);
					break;
				case 2:
					ui.lay_2->addWidget(mPbCh[(i * 8) + j]);
					break;
				case 3:
					ui.lay_3->addWidget(mPbCh[(i * 8) + j]);
					break;
				case 4:
					ui.lay_4->addWidget(mPbCh[(i * 8) + j]);
					break;
				case 5:
					ui.lay_5->addWidget(mPbCh[(i * 8) + j]);
					break;
				case 6:
					ui.lay_6->addWidget(mPbCh[(i * 8) + j]);
					break;
				case 7:
					ui.lay_7->addWidget(mPbCh[(i * 8) + j]);
					break;
				}
			}
		}
	}


	connect(ui.pushButton_ok, SIGNAL(clicked()), this, SLOT(OkClicked()));
	connect(ui.pushButton_cancel, SIGNAL(clicked()), this, SLOT(CancelClicked()));
	connect(ui.pushButton_all, SIGNAL(clicked()), this, SLOT(SelectAll()));
}

chmaskDialog::~chmaskDialog()
{
}

void chmaskDialog::OkClicked() {
	mMask = 0;
	for (int i = 0; i < mPbCh.size(); i++) {
		if(mPbCh[i]->isChecked())
            mMask |= (1LL << i); //i64
	}
	accept();
}
void chmaskDialog::CancelClicked() {
	reject();
}

void chmaskDialog::SelectAll() {
	if (ui.pushButton_all->isChecked()) {
		for (int i = 0; i < mPbCh.size(); i++) 
			mPbCh[i]->setChecked(true);
		ui.pushButton_all->setText("Deselect All");
	}
	else {
		for (int i = 0; i < mPbCh.size(); i++)
			mPbCh[i]->setChecked(false);
		ui.pushButton_all->setText("Select All");
	}
}
