/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		boardsListDialog.cpp
*	\brief
*	\author
*
******************************************************************************/

#include "boardsListDialog.h"
#include "WaveDump2.h"

boardsListDialog::boardsListDialog(WaveDump2 *parent, QList<QString> *list)
	: QDialog(parent)
	, mrow{}
{
	ui.setupUi(this);

	list_modified = false;
	mDevList = list;


	ui.tableWidget->setRowCount(mDevList->size());
	for (int i = 0; i < mDevList->size(); i++) {
		QString ID = (i == 0) ? "MASTER" : QString(SLAVE_BOARD).arg(i);		
		QTableWidgetItem *newItem = new QTableWidgetItem(ID);
		newItem->setTextAlignment(Qt::AlignHCenter);
		newItem->setSelected(false);
		ui.tableWidget->setItem(i, 0, newItem);
		QTableWidgetItem *newItem1 = new QTableWidgetItem(mDevList->at(i));
		newItem1->setTextAlignment(Qt::AlignHCenter);
		newItem1->setSelected(false);
		ui.tableWidget->setItem(i, 1, newItem1);
	}

	ui.pushButton_down->setEnabled(false);
	ui.pushButton_up->setEnabled(false);

	connect(ui.pushButton_up, SIGNAL(clicked()), this, SLOT(MoveUp()));
	connect(ui.pushButton_down, SIGNAL(clicked()), this, SLOT(MoveDown()));
	connect(ui.okButton, SIGNAL(clicked()), this, SLOT(OkClicked()));
	connect(ui.cancelButton, SIGNAL(clicked()), this, SLOT(CancelClicked()));
	connect(ui.tableWidget, SIGNAL(itemSelectionChanged()), this, SLOT(BoardSelectedChanged()));
}

void boardsListDialog::OkClicked() {
	mDevList->clear();
	int col = ui.tableWidget->columnCount();
	for (int i = 0; i < ui.tableWidget->rowCount(); i++) {
		mDevList->append(ui.tableWidget->item(i, 1)->text());
	}
	
	accept();
}
void boardsListDialog::CancelClicked() {
	reject();
}
void boardsListDialog::MoveUp() {
	QTableWidgetItem *currentItem = ui.tableWidget->takeItem(mrow, 1);
	QTableWidgetItem *upperItem = ui.tableWidget->takeItem(mrow -1, 1);

	ui.tableWidget->setItem(mrow, 1, upperItem);
	ui.tableWidget->setItem(mrow-1, 1, currentItem);
	ui.tableWidget->selectRow(mrow - 1);
}
void boardsListDialog::MoveDown() {
	QTableWidgetItem *currentItem = ui.tableWidget->takeItem(mrow, 1);
	QTableWidgetItem *lowerItem = ui.tableWidget->takeItem(mrow + 1, 1);

	ui.tableWidget->setItem(mrow, 1, lowerItem);
	ui.tableWidget->setItem(mrow + 1, 1, currentItem);
	ui.tableWidget->selectRow(mrow + 1);
}

void boardsListDialog::BoardSelectedChanged() {
	QTableWidgetItem *currentItem = ui.tableWidget->currentItem();
	if (currentItem == nullptr)
		return;
	mrow = currentItem->row();
	if (mrow == 0) {
		ui.pushButton_up->setEnabled(false);
		ui.pushButton_down->setEnabled(true);
	}
	else if (mrow == (mDevList->size() - 1)) {
		ui.pushButton_up->setEnabled(true);
		ui.pushButton_down->setEnabled(false);
	}
	else {
		ui.pushButton_up->setEnabled(true);
		ui.pushButton_down->setEnabled(true);
	}
}

boardsListDialog::~boardsListDialog(){
}
