/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		Statistics.cpp
*	\brief
*	\author
*
******************************************************************************/

#include "Statistics.h"

QVector<std::uint64_t> Statistics::mReadTrgCnt;
QVector<std::uint64_t> Statistics::mReadTrgCnt_prev;
QVector<std::uint64_t> Statistics::mProcTrgCnt;
QVector<std::uint64_t> Statistics::mLostTrgCnt;
QVector<std::uint64_t> Statistics::mBuildMissCnt;
QVector<std::uint64_t> Statistics::mReadByteCnt;
QVector<std::uint64_t> Statistics::mReadByteCnt_prev;
uint64_t Statistics::mTotBytesCnt;
uint64_t Statistics::mGlobalEventCnt;
uint64_t Statistics::mOutOfSyncCnt;
double Statistics::mCurrentTimeStamp_us;
QDateTime Statistics::mStartTime;

Statistics::Statistics() {
	clear();
}

Statistics::~Statistics() {
}

void Statistics::init(int size) {
	mReadTrgCnt.resize(size);
	mReadTrgCnt.fill(0);
	mReadTrgCnt_prev.resize(size);
	mReadTrgCnt_prev.fill(0);
	mReadByteCnt.resize(size);
	mReadByteCnt.fill(0);
	mReadByteCnt_prev.resize(size);
	mReadByteCnt_prev.fill(0);
	mProcTrgCnt.resize(size);
	mProcTrgCnt.fill(0);
	mLostTrgCnt.resize(size);
	mLostTrgCnt.fill(0);
	mBuildMissCnt.resize(size);
	mBuildMissCnt.fill(0);
	mTotBytesCnt = 0;
	mGlobalEventCnt = 0;
	mOutOfSyncCnt = 0;
	mCurrentTimeStamp_us = 0;
}


void Statistics::clear() {

	mReadTrgCnt.fill(0);
	mReadTrgCnt_prev.fill(0);
	mProcTrgCnt.fill(0);
	mLostTrgCnt.fill(0);
	mBuildMissCnt.fill(0);
	mReadByteCnt.fill(0);
	mReadByteCnt_prev.fill(0);

	mTotBytesCnt=0;
	mGlobalEventCnt=0;
	mOutOfSyncCnt=0;
	mCurrentTimeStamp_us = 0;
}

void Statistics::IncrReadTrgCnt(int dev, int n) {
	mReadTrgCnt.replace(dev, mReadTrgCnt.at(dev) + n);
}

void Statistics::SetReadTrgCnt_prev(int dev, std::uint64_t n) {
	mReadTrgCnt_prev.replace(dev, n);
}

void Statistics::IncrProcTrgCnt(int dev, int n) {
	mProcTrgCnt.replace(dev, mProcTrgCnt.at(dev) + n);
}
void Statistics::IncrLostTrgCnt(int dev, int n) {
	if(n)
		mLostTrgCnt.replace(dev, mLostTrgCnt.at(dev) + n);
}

void Statistics::IncrBuildMissCnt(int dev, int n) {
	mBuildMissCnt.replace(dev, mBuildMissCnt.at(dev) + n);
}
void Statistics::IncrReadByteCnt(int dev, int n) {
	mReadByteCnt.replace(dev, mReadByteCnt.at(dev) + n);
}

void Statistics::SetReadByteCnt_prev(int dev, std::uint64_t n) {
	mReadByteCnt_prev.replace(dev, n);
}

void Statistics::IncrGlobalEvCnt(int n) {
	mGlobalEventCnt += n;
}

void Statistics::IncrOutOfSyncEvCnt(int n) {
	mOutOfSyncCnt += n;
}

void Statistics::IncrTotBytesCnt(int n) {
	mTotBytesCnt += n;
}
