/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		DACOUTDialog.cpp
*	\brief
*	\author
*
******************************************************************************/

#include "DACOUTDialog.h"
#include <QtGlobal>
#include <QMessageBox>
#include <CAEN_FELib.h>

DACOUTDialog::DACOUTDialog(QWidget *parent, uint64_t Handle)
	: QDialog(parent)
{
	ui.setupUi(this);
	setWindowTitle("DAC OUT Setup");
	mHandle = Handle;


	char value[256] = { 0 };
	CAEN_FELib_ErrorCode err = (CAEN_FELib_ErrorCode)CAEN_FELib_GetValue(mHandle, "/par/DACOutStaticLevel", value);
	if (err != CAEN_FELib_Success) {
		QMessageBox::critical(this, tr("DAC OUT"), tr("Error reading current DAC level\n"));
	}
	double value_v = (QString(value).toDouble() * 2.) / 16383. - 1;
	ui.dBoxLevel->setValue(value_v);

	err = (CAEN_FELib_ErrorCode)CAEN_FELib_GetValue(mHandle, "/par/TestPulsePeriod", value);
	if (err != CAEN_FELib_Success) {
		QMessageBox::critical(this, tr("DAC OUT"), tr("Error reading current test pulse period\n"));
	}
	ui.dBox_T->setValue(QString(value).toDouble());

	err = (CAEN_FELib_ErrorCode)CAEN_FELib_GetValue(mHandle, "/par/TestPulseWidth", value);
	if (err != CAEN_FELib_Success) {
		QMessageBox::critical(this, tr("DAC OUT"), tr("Error reading current test pulse width\n"));
	}
	ui.dBox_W->setValue(QString(value).toDouble());

	err = (CAEN_FELib_ErrorCode)CAEN_FELib_GetValue(mHandle, "/par/TestPulseHighLevel", value);
	if (err != CAEN_FELib_Success) {
		QMessageBox::critical(this, tr("DAC OUT"), tr("Error reading current test pulse high level\n"));
	}
	value_v = (QString(value).toDouble() * 2.) / 16383. - 1;
	ui.dBox_HighLev->setValue(value_v);

	err = (CAEN_FELib_ErrorCode)CAEN_FELib_GetValue(mHandle, "/par/TestPulseLowLevel", value);
	if (err != CAEN_FELib_Success) {
		QMessageBox::critical(this, tr("DAC OUT"), tr("Error reading current test pulse low level\n"));
	}
	value_v = (QString(value).toDouble() * 2.) / 16383. - 1;
	ui.dBox_LowLev->setValue(value_v);


	ui.groupBox_User->setEnabled(false);
	ui.spinBox_Ch->setEnabled(false);
	ui.dBoxLevel->setEnabled(false);

	err = (CAEN_FELib_ErrorCode)CAEN_FELib_GetValue(mHandle, "/par/DACOutMode", value);
	if (err != CAEN_FELib_Success) {
		QMessageBox::critical(this, tr("DAC OUT"), tr("Error reading current DAC mode\n"));
	}
	if (QString(value).contains("Static", Qt::CaseInsensitive)) {
		if (ui.dBoxLevel->value() != 8192) {
			ui.cBoxMode->setCurrentIndex(1);
			ui.dBoxLevel->setEnabled(true);
		}
		else
			ui.cBoxMode->setCurrentIndex(0);
	}
	else if(QString(value).contains("Sin", Qt::CaseInsensitive))
		ui.cBoxMode->setCurrentIndex(2);
	else if (QString(value).contains("Ramp", Qt::CaseInsensitive))
		ui.cBoxMode->setCurrentIndex(3);
	else if (QString(value).contains("Square", Qt::CaseInsensitive)) {
		if(ui.dBox_T->value() == 16)
			ui.cBoxMode->setCurrentIndex(4);
		else if(ui.dBox_T->value() == 200)
			ui.cBoxMode->setCurrentIndex(5);
		else {
			if(ui.dBox_W->value() == 16)
				ui.cBoxMode->setCurrentIndex(6);
			else if (ui.dBox_W->value() == 999984)
				ui.cBoxMode->setCurrentIndex(7);
			else {
				ui.cBoxMode->setCurrentIndex(8);
				ui.groupBox_User->setEnabled(true);
			}
		}
	}
	else if (QString(value).contains("ChInput", Qt::CaseInsensitive)) {
		ui.cBoxMode->setCurrentIndex(9);
		ui.spinBox_Ch->setEnabled(true);
	}




	

	connect(ui.pushButton_ok, SIGNAL(clicked()), this, SLOT(OkClicked()));
	connect(ui.cBoxMode, SIGNAL(currentIndexChanged(int)), this, SLOT(ModeChanged(int)));
	connect(ui.dBoxLevel, SIGNAL(valueChanged(double)), this, SLOT(LevelChanged(double)));
	connect(ui.spinBox_Ch, SIGNAL(valueChanged(int)), this, SLOT(ChChanged(int)));
	connect(ui.dBox_HighLev, SIGNAL(valueChanged(double)), this, SLOT(HighLevelChanged(double)));
	connect(ui.dBox_LowLev, SIGNAL(valueChanged(double)), this, SLOT(LowLevelChanged(double)));
	connect(ui.dBox_T, SIGNAL(valueChanged(double)), this, SLOT(TChanged(double)));
	connect(ui.dBox_W, SIGNAL(valueChanged(double)), this, SLOT(WChanged(double)));
}

DACOUTDialog::~DACOUTDialog()
{
}

void DACOUTDialog::OkClicked() {
	accept();
}


void DACOUTDialog::ModeChanged(int mode) {
	CAEN_FELib_ErrorCode ret= CAEN_FELib_Success;
	char error[1024];
	int dacval;
	switch (mode) {
	case (0):
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/DACoutMode", "Static");
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/DACoutStaticLevel", "8192");
		ui.groupBox_User->setEnabled(false);
		ui.spinBox_Ch->setEnabled(false);
		ui.dBoxLevel->setEnabled(false);
		ui.label_2->setEnabled(false);
		ui.label_7->setEnabled(false);
		break;
	case (1):
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/DACoutMode", "Static");
		dacval = (int)(qRound((ui.dBoxLevel->value() * 4095) + 8191));
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/DACoutStaticLevel", QString("%1").arg(dacval).toStdString().c_str());
		ui.dBoxLevel->setEnabled(true);
		ui.groupBox_User->setEnabled(false);
		ui.spinBox_Ch->setEnabled(false);
		ui.label_2->setEnabled(true);
		ui.label_7->setEnabled(false);
		break;
	case (2):
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/DACoutMode", "Sin5Mhz");
		ui.groupBox_User->setEnabled(false);
		ui.spinBox_Ch->setEnabled(false);
		ui.dBoxLevel->setEnabled(false);
		ui.label_2->setEnabled(false);
		ui.label_7->setEnabled(false);
		break;
	case (3):
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/DACoutMode", "Ramp");
		ui.groupBox_User->setEnabled(false);
		ui.spinBox_Ch->setEnabled(false);
		ui.dBoxLevel->setEnabled(false);
		ui.label_2->setEnabled(false);
		ui.label_7->setEnabled(false);
		break;
	case (4):
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/TestPulsePeriod", "16");
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/TestPulseWidth", "8");
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/TestPulseLowLevel", "0");
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/TestPulseHighLevel", "65535");
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/DACoutMode", "Square");
		ui.groupBox_User->setEnabled(false);
		ui.spinBox_Ch->setEnabled(false);
		ui.dBoxLevel->setEnabled(false);
		ui.label_2->setEnabled(false);
		ui.label_7->setEnabled(false);
		break;
	case (5):
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/TestPulsePeriod", "200");
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/TestPulseWidth", "100");
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/TestPulseLowLevel", "65535");
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/TestPulseHighLevel", "0");
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/DACoutMode", "Square");
		ui.groupBox_User->setEnabled(false);
		ui.spinBox_Ch->setEnabled(false);
		ui.dBoxLevel->setEnabled(false);
		ui.label_2->setEnabled(false);
		ui.label_7->setEnabled(false);
		break;
	case (6):
	case (7):
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/TestPulsePeriod", "1000000");
		if (mode == 6) {
			ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/TestPulseWidth", "999984");
			ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/TestPulseLowLevel", "65535");
			ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/TestPulseHighLevel", "32767");
		}
		else {
			ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/TestPulseWidth", "16");
			ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/TestPulseLowLevel", "32767");
			ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/TestPulseHighLevel", "0");
		}
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/DACoutMode", "Square");
		ui.groupBox_User->setEnabled(false);
		ui.spinBox_Ch->setEnabled(false);
		ui.dBoxLevel->setEnabled(false);
		ui.label_2->setEnabled(false);
		ui.label_7->setEnabled(false);
		break;
	case (8):
		ui.dBox_T->blockSignals(true);
		ui.dBox_T->setValue(100);
		ui.dBox_T->blockSignals(false);
		ui.dBox_W->blockSignals(true);
		ui.dBox_W->setValue(20);
		ui.dBox_W->blockSignals(false);
		ui.dBox_LowLev->blockSignals(true);
		ui.dBox_LowLev->setValue(0);
		ui.dBox_LowLev->blockSignals(false);
		ui.dBox_HighLev->blockSignals(true);
		ui.dBox_HighLev->setValue(1);
		ui.dBox_HighLev->blockSignals(false);
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/TestPulsePeriod", QString("%1").arg(ui.dBox_T->value()).toStdString().c_str());
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/TestPulseWidth", QString("%1").arg(ui.dBox_W->value()).toStdString().c_str());
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/TestPulseLowLevel", QString("%1").arg((uint32_t)(qRound((ui.dBox_LowLev->value() * 16384) + 32767))).toStdString().c_str());
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/TestPulseHighLevel", QString("%1").arg((uint32_t)(qRound((ui.dBox_HighLev->value() * 16384)+ 32767))).toStdString().c_str());
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/DACoutMode", "Square");
		ui.groupBox_User->setEnabled(true);
		ui.spinBox_Ch->setEnabled(false);
		ui.dBoxLevel->setEnabled(false);
		ui.label_2->setEnabled(false);
		ui.label_7->setEnabled(false);
		break;
	case (9):
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/DACoutMode", "ChInput");
		ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/DACoutChSelect", QString("%1").arg(ui.spinBox_Ch->value()).toStdString().c_str());
		ui.groupBox_User->setEnabled(false);
		ui.spinBox_Ch->setEnabled(true);
		ui.dBoxLevel->setEnabled(false);
		ui.label_2->setEnabled(false);
		ui.label_7->setEnabled(true);
		break;
	}
	if (ret != CAEN_FELib_Success) {
		CAEN_FELib_GetLastError(error);
		QMessageBox::critical(this, tr("DAC OUT"), tr(error) + tr("\n DAC Mode could not be set\n"));
	}
}


void DACOUTDialog::LevelChanged(double l) {
	CAEN_FELib_ErrorCode ret = CAEN_FELib_Success;
	char error[1024];
	int dacval = (int)(qRound((l * 4095) +8191));
	ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/DACoutStaticLevel", QString("%1").arg(dacval).toStdString().c_str());
	if (ret != CAEN_FELib_Success) {
		CAEN_FELib_GetLastError(error);
		QMessageBox::critical(this, tr("DAC OUT"), tr(error) + tr("\n DAC Level could not be set\n"));
	}
}

void DACOUTDialog::ChChanged(int ch) {
	CAEN_FELib_ErrorCode ret = CAEN_FELib_Success;
	char error[1024];
	ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/DACoutChSelect", QString("%1").arg(ch).toStdString().c_str());
	if (ret != CAEN_FELib_Success) {
		CAEN_FELib_GetLastError(error);
		QMessageBox::critical(this, tr("DAC OUT"), tr(error) + tr("\n Channel could not be set\n"));
	}
}

void DACOUTDialog::HighLevelChanged(double l) {
	CAEN_FELib_ErrorCode ret = CAEN_FELib_Success;
	char error[1024];
	uint32_t dacval = (uint32_t)(qRound((l * 16384) + 32767));
	ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/TestPulseHighLevel", QString("%1").arg(dacval).toStdString().c_str());
	if (ret != CAEN_FELib_Success) {
		CAEN_FELib_GetLastError(error);
		QMessageBox::critical(this, tr("DAC OUT"), tr(error) + tr("\n High Level could not be set\n"));
	}
}

void DACOUTDialog::LowLevelChanged(double l) {
	CAEN_FELib_ErrorCode ret = CAEN_FELib_Success;
	char error[1024];
	uint32_t dacval = (uint32_t)(qRound((l * 16384) + 32767));
	ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/TestPulseLowLevel", QString("%1").arg(dacval).toStdString().c_str());
	if (ret != CAEN_FELib_Success) {
		CAEN_FELib_GetLastError(error);
		QMessageBox::critical(this, tr("DAC OUT"), tr(error) + tr("\n High Level could not be set\n"));
	}
}

void DACOUTDialog::TChanged(double T) {
	CAEN_FELib_ErrorCode ret = CAEN_FELib_Success;
	char error[1024];
	ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/TestPulsePeriod", QString("%1").arg(T).toStdString().c_str());
	if (ret != CAEN_FELib_Success) {
		CAEN_FELib_GetLastError(error);
		QMessageBox::critical(this, tr("DAC OUT"), tr(error) + tr("\n Period could not be set\n"));
	}
}

void DACOUTDialog::WChanged(double w) {
	CAEN_FELib_ErrorCode ret = CAEN_FELib_Success;
	char error[1024];
	ret = (CAEN_FELib_ErrorCode)CAEN_FELib_SetValue(mHandle, "/par/TestPulseWidth", QString("%1").arg(w).toStdString().c_str());
	if (ret != CAEN_FELib_Success) {
		CAEN_FELib_GetLastError(error);
		QMessageBox::critical(this, tr("DAC OUT"), tr(error) + tr("\n Width could not be set\n"));
	}
}