/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		CAENyaxismarker.cpp
*	\brief
*	\author
*
******************************************************************************/

#include "CAENyaxismarker.h"

CAENyaxismarker::CAENyaxismarker(QCPAxis *parentAxis) :
  QObject(parentAxis),
  mAxis(parentAxis)
{
  //tracer anchored at the right side of the axis rect
  mTracer = new QCPItemTracer(mAxis->parentPlot());
  mTracer->setVisible(false);
  mTracer->position->setTypeX(QCPItemPosition::ptAxisRectRatio);
  mTracer->position->setTypeY(QCPItemPosition::ptPlotCoords);
  mTracer->position->setAxisRect(mAxis->axisRect());
  mTracer->position->setAxes(0, mAxis);
  mTracer->position->setCoords(1, 0);
   
  //arrow anchored to the tracer
  mArrow = new QCPItemLine(mAxis->parentPlot());
  mArrow->setLayer("overlay");
  mArrow->setClipToAxisRect(false);
  mArrow->setHead(QCPLineEnding::esSpikeArrow);
  mArrow->end->setParentAnchor(mTracer->position);
  mArrow->start->setParentAnchor(mArrow->end);
  mArrow->start->setCoords(15, 0); //15 pixel long arrow

  mLine = new QCPItemLine(mAxis->parentPlot());
  QCPLineEnding *style = new QCPLineEnding(QCPLineEnding::esNone, 10, 10, false);
  mLine->setHead(*style);
  mLine->setSelectable(false);
  mLine->setPen(Qt::CustomDashLine);
}
 
CAENyaxismarker::~CAENyaxismarker(){

}
 
void CAENyaxismarker::setPen(const QPen &pen)
{
  mArrow->setPen(pen);
  mLine->setPen(pen);
}

void CAENyaxismarker::setVisible(bool visible) {
	mArrow->setVisible(visible);
	mLine->setVisible(visible);
}
 
void CAENyaxismarker::updatePosition(double value, double MaxX)
{
  // xcoord is always kept at 1 to fix it at the right of the axis.
  mTracer->position->setCoords(1, value);
   
  mArrow->end->setCoords(mAxis->offset(), 0);

  mLine->start->setCoords(0, value);
  mLine->end->setCoords(MaxX, value);
}
