/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		CAENcursor.cpp
*	\brief
*	\author
*
******************************************************************************/

#include "qcustomplot.h"
#include "CAENcursor.h"

VCursor::VCursor(QCustomPlot *parent_plot, double xc, QCPGraph *trace)
{
    Q_UNUSED(xc);//the cursor xc is set when it is drawn
    Line = new QCPItemLine(parent_plot);
    QCPLineEnding *style = new QCPLineEnding(QCPLineEnding::esSquare, 10, 10,false);
    Line->setHead(*style);
    Line->setSelectable(true);
    Line->setSelected(false);
	Line->setPen(Qt::DashDotLine);
    Point = new QCPItemTracer(parent_plot);
    Point->setGraph(trace);
    Point->setSelectable(true);
    Point->setSelected(false);
    Point->setStyle(QCPItemTracer::tsCircle);
	Point->setInterpolating(true);
	Point->setSize(8);
}


void VCursor::DrawCursor(double xc, double MinY, double MaxY){
	Point->setGraphKey(xc);
    Line->start->setCoords(Point->graphKey(), MinY);
    Line->end->setCoords(Point->graphKey(), MaxY);//by default the line ends at MaxY
    
}

void VCursor::SetColors(QPen color, QPen color_select){
    Line->setPen(color);
    Line->setSelectedPen( color_select );
    Line->setSelectable( true );

    Point->setPen(color);
    Point->setSelectedPen( color_select );
}

double VCursor::CurrentPositionX(){
    return Point->graphKey();
}

double VCursor::CurrentPositionY(){
    return Point->position->value();
}


void VCursor::DeleteFromPlot(QCustomPlot *plot){

    plot->removeItem(Line);
    plot->removeItem(Point);
}

bool VCursor::isSelected(){
    return (Line->selected() || Point->selected());
}

void VCursor::setSelected(bool state){
    Line->setSelected(state);
    Point->setSelected(state);
}

void VCursor::HandleCursorSelect(){
    if(Line->selected())
        Point->setSelected(true);
    else
        Point->setSelected(false);
}


VCursor::~VCursor()
{

}
