/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		CAENaxismarker.cpp
*	\brief
*	\author
*
******************************************************************************/

#include "CAENaxismarker.h"

CAENaxismarker::CAENaxismarker(QCPAxis *parentAxis) :
	QObject(parentAxis),
	mAxis(parentAxis)
{
	//tracer is not visivle visible but anchored to the axis rect
	mTracer = new QCPItemTracer(mAxis->parentPlot());
	mTracer->setVisible(false);
	mTracer->position->setTypeX(QCPItemPosition::ptPlotCoords);
	mTracer->position->setTypeY(QCPItemPosition::ptAxisRectRatio);
	mTracer->position->setAxisRect(mAxis->axisRect());
	mTracer->position->setAxes(mAxis, 0);
	mTracer->position->setCoords(0, 0); //ptAxisRectRatio system: 0 0 top left corner

	// the arrow parent is the tracer and its coordinate system is pixels (-15 = 15 pixel long arrow upside down)
	mArrow = new QCPItemLine(mAxis->parentPlot());
	mArrow->setLayer("overlay");
	mArrow->setClipToAxisRect(false);
	mArrow->setHead(QCPLineEnding::esSpikeArrow);
	mArrow->end->setParentAnchor(mTracer->position);
	mArrow->start->setParentAnchor(mArrow->end);
	mArrow->start->setCoords(0, -15);
}

void CAENaxismarker::setPen(const QPen &pen){
	mArrow->setPen(pen);
}

void CAENaxismarker::setColor(QColor color) {
	QPen new_pen(color, 2, Qt::SolidLine, Qt::SquareCap, Qt::RoundJoin);
	mArrow->setPen(new_pen);	
}

void CAENaxismarker::updatePosition(double value)
{
	//update tracer key pos, value pos is 0 = top axis of axes rect
	mTracer->position->setCoords(value, 0);
	// update arrow pos
	mArrow->end->setCoords(0, mAxis->offset());
}

void CAENaxismarker::updateOriginalPosition(double value)
{
	mOriginalPos = value;
}

void CAENaxismarker::setVisible(bool visible) {
	mArrow->setVisible(visible);
}

double CAENaxismarker::position() {
	return mTracer->position->coords().x();
}

CAENaxismarker::~CAENaxismarker()
{
	if (mTracer)
		mTracer->parentPlot()->removeItem(mTracer);
	if (mArrow)
		mArrow->parentPlot()->removeItem(mArrow);
}
