/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		CAENTreeWidgetItem.cpp
*	\brief
*	\author
*
******************************************************************************/

#include "CAENTreeWidgetItem.h"

CAENTreeWidgetItem::CAENTreeWidgetItem(CAENTreeWidgetItem *parent, QStringList &name, int type, std::uint64_t handle, const QString& qry)
	: QTreeWidgetItem(parent, name, type)
	, mHandle(handle)
	, mType(static_cast<CAEN_FELib_NodeType_t>(type))
	, mQry(qry) {
}

CAENTreeWidgetItem::CAENTreeWidgetItem(QStringList &name, int type, std::uint64_t handle, const QString& qry)
	: CAENTreeWidgetItem(nullptr, name, type, handle, qry) {
}

CAENTreeWidgetItem::CAENTreeWidgetItem()
	: QTreeWidgetItem()
	, mHandle{}
	, mType{}
	, mQry{}
{
}

CAENTreeWidgetItem::CAENTreeWidgetItem(int type)
	: QTreeWidgetItem(type)
	, mHandle{}
	, mType{}
	, mQry{}
{
}

CAENTreeWidgetItem::CAENTreeWidgetItem(CAENTreeWidgetItem *parent, int type)
	: QTreeWidgetItem(parent, type)
	, mHandle{}
	, mType{}
	, mQry{}
{
}

void CAENTreeWidgetItem::setHandle(std::uint64_t handle) {
	this->mHandle = handle;
}

std::uint64_t CAENTreeWidgetItem::getHandle() const {
	return this->mHandle;
}

void CAENTreeWidgetItem::setType(CAEN_FELib_NodeType_t type) {
	this->mType = type;
}

CAEN_FELib_NodeType_t CAENTreeWidgetItem::getType() const {
	return this->mType;
}

void CAENTreeWidgetItem::setQry(const QString& qry) {
	this->mQry = qry;
}

const QString& CAENTreeWidgetItem::getQry() const {
	return this->mQry;
}

const QString& CAENTreeWidgetItem::getRootName()const {
	return mRootName;
}

void CAENTreeWidgetItem::setRootName(const QString& name) {
	mRootName = name;
}
