/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		CAENTreeWidget.cpp
*	\brief
*	\author
*
******************************************************************************/

#include "CAENTreeWidget.h"

#include <QMessageBox>
#include <QMenu>

#include "CAEN_FELib.h"

CAENTreeWidget::CAENTreeWidget(QWidget *parent)
: QTreeWidget(parent)
, mItemHandle{} {
	setContextMenuPolicy(Qt::CustomContextMenu);
	connect(this, SIGNAL(customContextMenuRequested(const QPoint&)), SLOT(onCustomContextMenuRequested(const QPoint&)));
	connect(this, SIGNAL(itemClicked(QTreeWidgetItem*, int)), this, SLOT(itemClickedSlot(QTreeWidgetItem*, int)));
}

void CAENTreeWidget::onCustomContextMenuRequested(const QPoint& pos) {
	printf("hi\n");
	CAENTreeWidgetItem* item = (CAENTreeWidgetItem*)itemAt(pos);
	QModelIndex index = this->indexAt(pos);
	if (item) {
		// Note: We must map the point to global from the viewport to
		// account for the header.
		showContextMenu(item, viewport()->mapToGlobal(pos));
	}
}

void CAENTreeWidget::showContextMenu(void* CAENitem, const QPoint& globalPos) {
	QMenu menu;
	QAction actionGet;
	QAction actionSet;
	CAENTreeWidgetItem *item = (CAENTreeWidgetItem *)CAENitem;
	this->mItemHandle = item->getHandle();
	this->mQry = item->getQry();
	this->mRootName = item->getRootName();

	switch ((CAEN_FELib_NodeType_t)item->type()) {
	case CAEN_FELib_NodeType_t::CAEN_FELib_PARAMETER:
		actionGet.setText("Show in manual controller");
		actionGet.setParent(this);
		connect(&actionGet, SIGNAL(triggered()), this, SLOT(showManualPClicked()));
		menu.addAction(&actionGet);
		break;
	case CAEN_FELib_NodeType_t::CAEN_FELib_COMMAND:
		actionSet.setText("Show in manual controller");
		actionSet.setParent(this);
		connect(&actionSet, SIGNAL(triggered()), this, SLOT(showManualCClicked()));
		menu.addAction(&actionSet);
		break;
	default:
		break;
	}

	menu.exec(globalPos);
}

uint64_t CAENTreeWidget::getItemHandle() const {
	return this->mItemHandle;
}

const QString& CAENTreeWidget::getQuery() const {
	return mQry;
}

const QString& CAENTreeWidget::getRootName() const {
	return mRootName;
}

void CAENTreeWidget::showManualPClicked() {
	emit manualPClickedSignal(this);
}

void CAENTreeWidget::showManualCClicked() {
	emit manualCClickedSignal(this);
}

void CAENTreeWidget::itemClickedSlot(QTreeWidgetItem* itm, int col)
{
	emit itemClickedSignal((CAENTreeWidgetItem *)itm, col);


}
