/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		CAENSwitch.cpp
*	\brief
*	\author
*
******************************************************************************/

#include "CAENSwitch.h"

#include <qpainter.h>
#include <qpainterpath.h>
#include <qfont.h>
#include <qbrush.h>

CAENSwitch::CAENSwitch(QString onString, QString offString, int shape, QWidget *parent) :
	QAbstractButton(parent)
{
	setCheckable(true);

	onStr = onString;
	offStr = offString;
	shapeFlag = shape;

	setMinimumHeight(30);
	setMinimumWidth(60);

	setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Preferred);
}

void CAENSwitch::paintEvent(QPaintEvent* event)
{
	//! to silence compiler
	Q_UNUSED(event);

	QPainter painter(this);

	QFont f = painter.font();
	//f.setFamily(FONTFAMILY);

	int dim;
	int border;
	int fontDim;
	QPainterPath outerPath, innerPath;
	//	QPainterPath fillPath;
	QRect r;
	QBrush brInt, brBrd, brSw;
	QColor txtCol;
	QColor brdIntClr;
	QString str;
	outerPath.setFillRule(Qt::WindingFill);
	switch (shapeFlag) {
	case 0:		//! rounded
	default:
	{
		border = 4;
		dim = ((width() / 3)<(height() / 2)) ? (width() / 3) : (height() / 2);
		f.setStretch(QFont::ExtraCondensed);
		fontDim = (dim - (border * 2))*1.3;
		outerPath.addEllipse(QPointF(dim + border, dim), dim - (border * 2), dim - (border * 2));
		outerPath.addRect(dim + border, (border * 2), width() - ((dim + border) * 2), ((dim - (border * 2)) * 2));
		outerPath.addEllipse(QPointF(width() - (dim + border), dim), dim - (border * 2), dim - (border * 2));

		QPointF p;
		int x = dim / 2;
		if (isChecked()) {
			p = QPointF(width() - (dim + border), dim);
			r = QRect(x + (border * 2), (border * 2), (width() - (((dim + (border * 2)) * 2) + x)), ((dim - (border * 2)) * 2));
			str = onStr;
			brInt = QBrush(QColor(104, 204, 56));
			txtCol = QColor(240, 240, 240);
			brBrd = QBrush(QColor(13, 90, 0));
			brdIntClr = QColor(Qt::gray);
			brInt = QBrush(Qt::white);
		}
		else {
			p = QPointF(dim + border, dim);
			r = QRect(dim * 2 + (border * 2), (border * 2), (width() - (((dim + (border * 2)) * 2) + x)), ((dim - (border * 2)) * 2));
			str = offStr;
			brInt = QBrush(QColor(205, 205, 205));
			txtCol = QColor(88, 88, 88);
			brBrd = QBrush(QColor(88, 88, 88));
			brdIntClr = QColor(Qt::gray);
			brSw = brBrd;
		}
		innerPath.addEllipse(p, (dim - (border * 2)) - 2, (dim - (border * 2)) - 2);
	}
	break;
	case 1:		//! rect
	{
		border = 2;
		dim = ((width() / 2)<(height())) ? (width() / 2) : (height());
		f.setStretch(QFont::Condensed);
		fontDim = dim / 2;
		outerPath.addRect(border, border, (width() - (border * 2)), (dim - (border * 2)));
		int intBrd = border * 2;
		int rectIntDim = dim - (intBrd * 2);
		if (isChecked()) {
			innerPath.addRect((width() - rectIntDim - intBrd), intBrd, rectIntDim, rectIntDim);
			r = QRect(intBrd, intBrd, width() - dim - intBrd, rectIntDim);
			str = onStr;
			brInt = QBrush(QColor(104, 204, 56));
			txtCol = QColor(240, 240, 240);
			brBrd = QBrush(QColor(13, 90, 0));
			brdIntClr = QColor(Qt::gray);
			brSw = QBrush(Qt::white);
		}
		else {
			innerPath.addRect(intBrd, intBrd, rectIntDim, rectIntDim);
			r = QRect((intBrd * 2 + rectIntDim), intBrd, width() - (intBrd * 3 + rectIntDim), rectIntDim);
			str = offStr;
			brInt = QBrush(QColor(205, 205, 205));
			txtCol = QColor(88, 88, 88);
			brBrd = QBrush(QColor(88, 88, 88));
			brdIntClr = QColor(Qt::gray);
			brSw = brBrd;
		}
	}
	break;
	}

	painter.fillPath(outerPath, brInt);
	painter.fillPath(innerPath, brSw);
	//	fillPath = outerPath.subtracted(innerPath);

	painter.setRenderHint(QPainter::Antialiasing);
	//	painter.fillPath(fillPath, brInt);
	painter.strokePath(outerPath.simplified(), QPen(brBrd, 2));
	painter.strokePath(innerPath, QPen(brdIntClr, 1));
	f.setPixelSize(fontDim);
	painter.setFont(f);
	painter.setPen(txtCol);
	painter.drawText(r, Qt::AlignCenter, str);

}


QString	CAENSwitch::getOnString()
{
	return onStr;
}

QString CAENSwitch::getOffString()
{
	return offStr;
}

QString CAENSwitch::getCurrentString()
{
	QString retVal;
	if (isChecked())
		retVal = onStr;
	else
		retVal = offStr;

	return retVal;
}

CAENSwitch::~CAENSwitch()
{

}
