/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		CAENDig2Script.cpp
*	\brief
*	\author
*
******************************************************************************/

#include "CAENDig2Script.h"
#include "CAENFELibException.h"

CAENDig2Script::CAENDig2Script(QString filename){

	mFilename = filename;
	mFile = new QFile(mFilename);
	mFile->open(QIODevice::WriteOnly | QIODevice::Truncate);
	mout.setDevice(mFile);
}

void CAENDig2Script::AddAction(QString action, QString dev_name, QString par_name, QString value) {
	mout << ACTION_HW << " " << dev_name << " " << action << " " << par_name << " " << value << ENDL;
	mout.flush();
}


void CAENDig2Script::AddSWAction(QString action, QString value) {
	if(value == "")
		mout << ACTION_SW << " " << action << ENDL;
	else
		mout << ACTION_SW << " " << action << " " << value << ENDL;
	mout.flush();
}


CAENDig2Script::~CAENDig2Script()
{
	mFile->close();
}
