#!/bin/bash
DEST_APP_DIR="/usr/local/bin"
echo "Installing WaveDump2..."

# Verifica della versione di GCC (6.3 o superiore)
GCC_INSTALLED_VERSION=$(gcc --version | head -n 1 | awk '{print $NF}')
REQUIRED_GCC="6.3"

if [[ "$(echo -e "$GCC_INSTALLED_VERSION\n$REQUIRED_GCC" | sort -V | head -n 1)" == "$REQUIRED_GCC" ]]; then
    echo "GCC version is adequate ($GCC_INSTALLED_VERSION)"
else
    echo "GCC version is too old. Please install GCC $REQUIRED_GCC or higher."
fi

# Verifica della versione di glibc (glibc 2.24 o superiore)
GLIBC_VERSION=$(ldd --version | head -n 1 | awk '{print $NF}')
REQUIRED_GLIBC_VERSION="2.24"

if [[ "$(echo -e "$GLIBC_VERSION\n$REQUIRED_GLIBC_VERSION" | sort -V | head -n 1)" == "$REQUIRED_GLIBC_VERSION" ]]; then
    echo "glibc version is adequate ($GLIBC_VERSION)"
else
    echo "glibc version is too old. Please install glibc $REQUIRED_GLIBC_VERSION or higher."
fi

# Verifica della versione di glibcxx (g++ 5.4.1 o superiore)
GCC_VERSION=$(g++ --version | head -n 1 | awk '{print $NF}')
REQUIRED_GCC_VERSION="5.4.1"

if [[ "$(echo -e "$GCC_VERSION\n$REQUIRED_GCC_VERSION" | sort -V | head -n 1)" == "$REQUIRED_GCC_VERSION" ]]; then
    echo "g++ version is adequate ($GCC_VERSION)"
else
    echo "g++ version is too old. Please install g++ $REQUIRED_GCC_VERSION or higher."
fi

chmod +x `pwd`/WaveDump2.sh
ln -fs `pwd`/WaveDump2.sh $DEST_APP_DIR/WaveDump2
echo "Done"
exit 0
