/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		traceDataPanel.h
*	\brief
*	\author
*
******************************************************************************/

#ifndef TRACEDATAPANEL_H
#define TRACEDATAPANEL_H

#include <QWidget>
#include <QPushButton>
#include <QVector>
#include <QString>
#include <QSpinBox>
#include <QLabel>
#include <QVBoxLayout>
#include <QScrollArea>

#include "CAENPushButton.h"


class traceDataPanel : public QWidget
{
	Q_OBJECT

public:
	traceDataPanel(QWidget *parent);
	~traceDataPanel();
	void addDevice(QString name);
	void setMaxEv(QString name,uint32_t ev);
	void removeAllDevices();
	void removeDevice(QString name);
	void showEvData(QString name, int ev, quint64 t);
	void DisableDev(int t);
	void EnableDev(int t);

	
signals:
	void NextEvSelected(QString devname, int n);

private:
	QVector<QLabel*> mDev;
	QVector<QSpinBox*> mEvNumber;
	QVector<QLineEdit*> mEvTStamp;
	QVector<QString> mDevices;
	QVBoxLayout *scrolllLayout;
	QScrollArea *area;
	QVector<QString> mDevNames;
	QVector<QLabel*> mLabels;
	QVector<QLabel*> mLabels1;
	QVector<QLabel*> mLabels2;
	QWidget *data;


public slots:
	void EvNumberChanged(int);
 
};

#endif // TRACEDATAPANEL_H
