/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		statisticsPanel.h
*	\brief
*	\author
*
******************************************************************************/

#pragma once
#ifndef STATISTICSPANEL_H
#define STATISTICSPANEL_H

#include <QWidget>
#include <QTime>
#include <QElapsedTimer>
#include "ui_statisticsPanel.h"
#include "CAENDig2Device.h"
#include "CAENDevice.h"
#include "Statistics.h"

class WaveDump2;

class statisticsPanel : public QWidget
{
	Q_OBJECT

public:
	statisticsPanel(WaveDump2 *parent = nullptr);
	~statisticsPanel();
	void fillDevColumns(const QVector<QString> *dev_names, const QVector<int> *channels);
	void fillDevices(QList<CAENDevice *> dev);
	void resetTime() { mStartAcqTimer.restart(); }
	void clearStats() { ui.tabWidget_stats->clearContents(); }

public slots:
	void showData(QVector<int>, QVector<double>);
	void showStats();
	void showDevStatus(int dev, QString status);
	void clear();


private:
	Ui::statisticsPanel ui;
	WaveDump2 * const mWaveDump;
	QVector<QString> mDev_names;
	QVector<int> mChannels;
	QElapsedTimer mStartAcqTimer;
	QDateTime mLastUpdateTime;
	uint64_t mLastDevTime[100] = {0};
	int mNdevices;
};

#endif
