/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		plotPanel.h
*	\brief
*	\author
*
******************************************************************************/

#ifndef PLOTPANEL_H
#define PLOTPANEL_H

#include <QWidget>
#include <QVector>
#include <QMouseEvent>
#include <QString>
#include <QColor>
#include <QAction>
#include <QDockWidget>

#include "qcustomplot.h"
#include "palettePanel.h"
#include "traceDataPanel.h"
#include "CAENcursor.h"
#include "OscilloscopeTools.h"
#include "CAENaxismarker.h"
#include "CAENyaxismarker.h"

#define X_TICKS		10
#define Y_TICKS		5

#define PLOT_SCALE_ABSOLUTE 0
#define PLOT_SCALE_RELATIVE 1

#define PLOT_TYPE_WAVEFORMS 0
#define PLOT_TYPE_FFT 1
#define PLOT_TYPE_SAMPLES_HISTO 2

#define NPLOTTRACES		8

#define DIG2	0
#define DIG1	1

static const QPoint points[5] = {
	QPoint(0, 0),
	QPoint(0, 10),
	QPoint(20, 10),
	QPoint(30, 5),
	QPoint(20, 0),
};

namespace Ui {
class plotPanel;
}

class plotPanel : public QMainWindow
{
	Q_OBJECT

public:
	explicit plotPanel(QWidget *parent, int traces);
	~plotPanel();
	int ActiveTrace=0;
	int PlotType = PLOT_TYPE_WAVEFORMS;
	void updatePalette(int cmd, const QString& devices, const QVector<QString>& names);
	int getTraces();
	const QVector<QString>& getDevToPlot() const;
	const QVector<int>& getChanToPlot() const;
    void setXAxis(double lower, double upper, int uom);
    void setYAxis(double lower, double upper, int uom);
	void NewCursors(bool enable);
	void doReplot() { mPlot->replot(); }
	void setC1trace(int t) { mC1Trace = t; }
	void setC2trace(int t) { mC2Trace = t; }
	double getMaxX() { return mMaxX; }
	double getMinX() { return mMinX; }
	double getMaxY() { return mMaxY; }
	double getMinY() { return mMinY; }
	int getUoMX() { return mUomX; }
	int getUoMY() { return mUomY; }
	QCPAxis *getXAxis() { return mPlot->xAxis; }
	QCPAxis *getYAxis() { return mPlot->yAxis; }
	void updateXPosInfo(double max, double min, double incr, double val, double f);
	void updatePreTrgInfo(double val);
	void updateOffsetInfo(double val); //offset has changed for the active trace
	void updateOffsetInfo1(QString name, int ch, double val); //offset has changed for one of the other traces
	void updateThrInfo(double max,double min, double incr, double val, double f);
	void setXPos(double pos);
	void setThr(double thr);
	void setNewOffset(double value);
	QColor getTraceColor(int t) { return mTrace[t]->pen().color(); }
	void setActiveTrace(int index);
	QString getActiveTraceDev() { 
		return mTracesDevMap.value(ActiveTrace);
	}
	void setActiveDevClass(int dclass);
	int getActiveTraceCh() {return mTracesChMap.value(ActiveTrace);	}
	QString getTraceDev(int trace) {return mTracesDevMap.value(trace);}
	int getTraceCh(int trace) {	return mTracesChMap.value(trace);}
	int getPlotScale() { return mPlotScale; }
	void setPlotScale( int scale, bool enable);
	void updateBaselines(QString devname, int nbit, QVector<double> factor, QVector<double> baselines);
	void updateGains(QString devname, QVector<double> gains);
	void setXZoomCenter(double x) { mXZoomCenter = x; }
	double getZoomCenter() {return mXZoomCenter;}
	bool cursorsEnabled() { return mCursorsEnabled; }
	void OffsetToAll(double value);
	void ThresholdToAll(double value);
	void updateTSampl(double value) { mTSampl_ns = value; }
	bool isTraceVisible(int t) { return mTracesVisible[t]; }
	void resetSumCount() { mSummed = 0; }
	void TraceEnableCmd(int trace, bool enable);
	void TraceChangeCmd(int trace, QString dev, int ch);
	void ShowToolsCmd(bool show);
	void ShowPaletteCmd(bool show);
	void FreezeCmd(bool freeze);
	void PlotTypeChangeCmd(int type);
	void NAvgChangeCmd(int n);
	void RemoveDevFromPalette(QString devname);
	void showCursorPositions();
	void calcNewCursorPositions(double x);
	void enableOfflineMode(bool enable);
	void addOfflineDevice(QString devname);
	void setMaxEvNumber(QString name, uint32_t N);
	void removeOfflineDevice(QString devname);
	void showNewEvData(QString name, int ev, quint64 t);


public slots:
	void plotData(QVector< QVector< double > >, QVector< QVector< double > >, QVector<bool>, QVector<double>, double MaxY);
	void onMouseMove(QMouseEvent *event);
	void onMouseRelease(QMouseEvent *event);
	void onMousePress(QMouseEvent *event);
	void onMouseDoubleClick(QMouseEvent *event);
	void onXRangeChanged(const QCPRange &range);
	void onYRangeChanged(const QCPRange &range);
	void ThrShow(int checked);
	void XPosShow(int checked);
	void TraceColorChanged(int trace, QPen pen);
	void TraceEnableChanged(int trace, int enable);
	void updateDevTrace(const QString& device, int t);
	void PlotTraceChanged(int, QString, int);
	void GoToNextEvent(QString, int);
	void EnableEvDataTab(bool enable);
	void LockDataDevice(int t);
	void UnLockDataDevice(int t);
	void ClearPlot();

signals:
	void tracesChanged(QVector<QString>, QVector<int>);
	void NewCursorPositions(QVector<double>);
	void xPosChanged(double);
	void ThrChanged(double, bool);
	void OffsetChanged(QString, int, double, bool);
	void ActiveTraceChanged(QString, int);
	void GenericTraceChanged(QString, int);
	void ActiveTraceColorChanged();
	void ScaleChanged();
	void TypeChanged();
	void ToolsOpen(bool);
	void PlotFreeze(bool);
	void PaletteOpen(bool);
	void NWaves(int);
	void TraceEnabled(int, int);
	void TraceChanged(int, QString, int);
	void ClearPlotData();
	void ChangePlotTime(double val);
	void NewEventToLoad(QString devname, int ev);


private:
	Ui::plotPanel *ui;
	QCustomPlot *mPlot;
	QVector <QCPGraph*> mTrace;
	QColor	**mTraceColor;
	palettePanel *mPalettePan;
	traceDataPanel *mTraceDataPan;
	QToolBar *mToolBar;
	QAction *mrate_action;
	QAction* mlabel_rate_action;
	OscilloscopeTools *mTools;
	int mTraces;
	int mNAvg=1;
	int mSummed = 0;
	QAction *mFreezeAct;
	QAction *mPaletteAct;
	QAction *mToolsAct;
	QAction *mScaleAct;
	QAction* mWaveformsAct;
	QAction* mFFTAct;
	QAction* mHistoAct;
	QDockWidget *mPaletteDock;
	QDockWidget *mToolsDock;
	QLabel *mLabel_avg;
	QSpinBox* mSBox_avg;
	QLabel* mLabel_rate;
	QDoubleSpinBox* mDBox_rate;
	QTabWidget *mTab;
	bool mFreezePlot = false;
	Qt::GlobalColor chooseDefaultColor(int i);
	bool mElementSelected;
	double mMaxX;      //max  x value given by recordlength (us)
	double mMinX=0;
	double mMaxY;      //max  y value 
	double mMinY;      //min  y value
	double mXscale_f = 1.0;
	QVector<double> mXPos; //contains info about the reclen (samples or us)
	double mXZoomCenter=0.5; //position of zoom center
	double mOffset;
	double mTSampl_ns;
	QVector<double> mThr;
	QRubberBand *mRubberBand;
	QPoint mRectOrigin;
	VCursor *Cursor1;
	VCursor *Cursor2;
	int mC1Trace;
	int mC2Trace;
	bool mCursorsEnabled;
	bool mThrVisible=false;
	bool mPositionVisible = false;
	int mUomX;
	int mUomY;
	double mActiveTraceThr;
	int mPlotScale = PLOT_SCALE_RELATIVE;
	bool mToolsActive = false;
	int mActiveTraceDevClass = DIG2;
	CAENaxismarker *mPreTrgMarker;  //pre-trigger marker
	CAENyaxismarker *mThrMarker;  //threshold marker
	QVector<QCPItemPixmap *> mZeroMarker;  //Zero marker
	QVector<QCPItemTracer *> mZeroTracer; //Zero tracer
	QCPItemLine *mPositionMarker;
	QSharedPointer<QCPAxisTickerFixed> fixedTickerX;
	QSharedPointer<QCPAxisTickerFixed> fixedTickerY;
	QHash<int, int> mTracesChMap;
	QHash<int, QString> mTracesDevMap;
	bool mUpdatingTraces = false;
	QVector<double> mTracesBaselines; //baselines of the traces in plot
	QVector<double> mTracesGains; //input gains of the traces in plot
	QVector<int> mTracesADCBits; //number of ADC bits of the traces in plot
	QVector<double> mTracesSampleTomV; //samples to V factor for the plot traces
	QVector<bool> mTracesVisible; //visibility of the traces
	bool mplottypechanged = false;
	double FindXWithNonZeroY(QCPGraph *trace, int start, int end);
	void ElementClicked(QCPAbstractItem *item, QMouseEvent *event);
	void popolateToolBar();
	void UpdateZeroMarkers();
	void UpdateThrMarker();



private slots:
	void freezeToggle();
	void showPalette();
	void showTools();
	void switchPlotScale();
	void paletteChanged(const QVector<QString>&, const QVector<int>&, int);
	void plotTypeWaveforms();
	void plotTypeFFT();
	void plotTypeHisto();
	void NAvgChanged(int);
	void PlotTimeChanged(double);


};

#endif // PLOTPANEL_H
