/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		palettePanel.h
*	\brief
*	\author
*
******************************************************************************/

#ifndef PALETTEPANEL_H
#define PALETTEPANEL_H

#include <QWidget>
#include <QPushButton>
#include <QVector>
#include <QString>
#include <QComboBox>

#include "CAENPushButton.h"
#include "qcustomplot.h"


class palettePanel : public QWidget
{
	Q_OBJECT

public:
	palettePanel(QWidget *parent, int ntraces, QCPGraph **traces);
	~palettePanel();
	void updatePalette(int cmd, const QString& device, const QVector<QString>& names);
	const QVector<QString>& getDevToPlot() const;
	const QVector<int>& getChanToPlot() const;
	void TraceEnableCmd(int trace, bool enable);
	void TraceChangeCmd(int trace, QString dev, int ch);
	
signals:
	void paletteChanged(QVector<QString>, QVector<int>, int);
	void OffsetChanged(QString dev, int ch, int value);
	void colorChanged(int trace, QPen pen);
	void traceEnableChanged(int,int);
	void singleDevChanged(const QString&, int);
	void TraceToPlotChanged(int, QString, int); //notify for settings save option

private:
	QCPGraph **mTraces;
	int mNtraces;
	QVector<QComboBox*> mCbDev;
	QVector<QComboBox*> mCbChannels;
	QVector<QCheckBox*> mChTraces;
	QVector<QString> mDev;
	QVector<QVector<QString>> mChannels;
	QVector<QString> mDevToPlot;
	QVector<int> mChanToPlot;

private slots:
	void openPalette(CAENPushButton *b);
	void singlecbDevChanged(int);
	void cbChannelChanged(int);
	void traceEnable(int);

public slots:
	void cbDevChanged(int);
 
};

#endif // PALETTEPANEL_H
