/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		openDialog.h
*	\brief
*	\author
*
******************************************************************************/

#pragma once
#ifndef OPENIALOG_H
#define OPENIALOG_H

#include <QObject>
#include <QDialog>
#include <QString>
#include <QStringList>
#include <QCompleter>

#include "ui_openDialog.h"

#define CONN_TYPE_ETH	0
#define CONN_TYPE_USB	1

#define CONN_TYPE_USB_1				0
#define CONN_TYPE_USB_A4818			1
#define CONN_TYPE_USB_V4718			2
#define CONN_TYPE_OPTILINK			3
#define CONN_TYPE_ETH_V4718			4

class WaveDump2;

class openDialog : public QDialog
{
	Q_OBJECT

public:
	explicit openDialog(WaveDump2 *parent = 0);
	~openDialog();
	void increaseProgressBar();

private:
	Ui::openDialog * const ui;
	WaveDump2 * const mWaveDump;
	bool mConnecting = false;
	QString mIniFile;
	QStringList mIpList;
	QStringList mNameList;
	QCompleter *mCompleterIp;
	QCompleter *mCompleterName;
	QString getDig1ConnectionPath();

	void showProgress(bool flag);

private slots:
	void OkButtonClick();
	void CancelButtonClick();
	void ReconnectButtonClick();
	void ConnTypeChanged(int);
	void ConnTypeChanged_1(int);
};

#endif // OPENIALOG_H
