/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		manualControllerPanel.h
*	\brief
*	\author
*
******************************************************************************/

#ifndef TOPPANEL_H
#define TOPPANEL_H

#include <cstdint>

#include <QWidget>
#include <QHash>

#include "openDialog.h"


namespace Ui {
class manualControllerPanel;
}

class WaveDump2;

class manualControllerPanel : public QWidget
{
	Q_OBJECT

public:
	explicit manualControllerPanel(WaveDump2 *parent = nullptr);
	~manualControllerPanel();
	void showData(std::uint32_t handle, const QString& rootName, const QString& Qry, bool f);
	void disableAll();
	void addDevice(const QString& name, std::uint64_t handle);
	void removeDevice(const QString& name);

signals:
	void ManualExec();

private:
	Ui::manualControllerPanel * const ui;
	WaveDump2 *mWaveDump;
	QHash<QString, std::uint64_t> mDevices;
	std::uint64_t mRootHandle;

private slots:
	void resetFields();
    void resetFields(int);
	void getValue();
	void setValue();
	void sendCMD ();
	void enableValue();

};

#endif // TOPPANEL_H
