/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		logPanel.h
*	\brief
*	\author
*
******************************************************************************/

#ifndef LOGPANEL_H
#define LOGPANEL_H

#include <QWidget>
#include <QToolBar>
#include <QFile>
#include <QTextStream>
#include <QElapsedTimer>
#include <CAEN_FELib.h>


namespace Ui {
class logPanel;
}


class logPanel : public QWidget
{
	Q_OBJECT

public:
	explicit logPanel(QWidget *parent = nullptr);
	~logPanel();
	void add2Log(const QString&, const QString&, const QString&, const QString&, CAEN_FELib_ErrorCode);
	void add2Log(const QString& sentence, bool res);

private:
	Ui::logPanel * const ui;
	QToolBar *mToolBar;
	QFile *mLogfile;
	QTextStream mout;
	QElapsedTimer mlogTimer;
	QString elapsedTime_s() { return QString("%1").arg(mlogTimer.elapsed() / 1000);	}

private slots:

};

#endif // LOGPANEL_H
