/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		infoPanel.h
*	\brief
*	\author
*
******************************************************************************/

#pragma once
#ifndef INFOPANEL_H
#define INFOPANEL_H

#include <QWidget>
#include <QTimer>
#include <QTableWidgetItem>
#include <QTextEdit>
#include <QHeaderView>
#include <QGridLayout>
#include <QCloseEvent>
#include "ui_infoPanel.h"
#include "CAENDig2Device.h"
#include "CAENDig1Device.h"

class infoPanel : public QWidget
{
	Q_OBJECT

public:
	infoPanel(QWidget* parent, QList<CAENDevice*>devices, QString active_dev);
	~infoPanel();
	void Quit();

public slots:
	void showTemperatures();


private:
	Ui::infoPanel ui;
	QList<CAENDevice*>mDevs;
	QVector<QTableWidget*> mTtables;
	QTimer* TTimer;
	void closeEvent(QCloseEvent* event);
};

#endif
