/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		discoveryDevicesDialog.h
*	\brief
*	\author
*
******************************************************************************/

#pragma once
#ifndef DISCONVERY_H
#define DISCONVERY_H

#include <cstdint>

#include <QDialog>
#include <QProgressBar>
#include <QStatusBar>
#include <QString>
#include <QTimer>
#include <QFuture>
#include <QModelIndex>

#include "ui_discoveryDevicesDialog.h"


class WaveDump2;

class discoveryDevicesDialog : public QDialog
{
	Q_OBJECT

public:
	explicit discoveryDevicesDialog(WaveDump2 *parent = 0);
	~discoveryDevicesDialog();
	int getType() const;
	const QString& getAddress() const;

private:
	Ui::discoveryDevicesDialog * const ui;
	WaveDump2 * const mWaveDump;
	QString mName;
	QString mType;
	QString mSerNum;
	QString mAddress;
	QProgressBar *mMainProgressBar;
	bool mL2r = true;
	QTimer *mTimer;
	QFuture<QString> mAsyncScan;
	QFuture<uint64_t> mAsyncConnect;

	QString scan(int timeout);
	std::uint64_t addBoard(const QString& type, const QString& address);
	
private slots:
	void update();
	void start();
	void addDevice(QModelIndex const&);
};

#endif // DISCONVERY_H
