/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		deviceReadoutThread.h
*	\brief
*	\author
*
******************************************************************************/

#pragma once
#ifndef DEVICEREADOUTTHREAD_H
#define DEVICEREADOUTTHREAD_H

#include <QThread>
#include <QMutex>
#include <QWaitCondition>
#include <QVector>
#include <QFile>
#include "CAENDevice.h"
#include "CAENDig2Event.h"
#include "Statistics.h"
#include "dataSaveThread.h"

class WaveDump2;

class deviceReadoutThread : public QThread
{
	Q_OBJECT

public:
	deviceReadoutThread(WaveDump2 *w, CAENDevice *dev, std::uint32_t runId, ::uint32_t upRate);
	~deviceReadoutThread();
	void run();
	void startRun();
	bool isRunning() { return mDoRead; }
	bool devQueueInited = false;
	void setRawdataFilename(QString filename) { mRawDataFile = filename; }
	void setNextEvToLoad(int ev) { Next_Ev_To_Load = ev; }
	QMutex Read_Ev_mutex;
	QWaitCondition waitNextEvCondition;
	int Next_Ev_To_Load=0;

signals:
	void ReadoutError(QString, CAEN_FELib_ErrorCode);
	void GenericError(QString);
	void StopReadout(QString);
	void NewEvLoaded(QString, int, quint64);
	void ErrorLoadingEv(QString, int);
	void LoadChMask(QString,quint64);

public slots:
	void stopRun();
	void SaveThreadFinished();

private:
	WaveDump2 *mWaveDump2 = nullptr;
	CAENDevice *mDevice = nullptr;
	QString mName;
	std::uint64_t mDevHandle;
	std::uint64_t mReadPointHandle;
	std::uint16_t mNumOfchannels;
	std::uint64_t mChEnableMask;
	QVector<CAENDig2Event *> *mEvents;
	std::uint32_t mUpdateRate;
	uint32_t mBuffer40[9];
	uint16_t mChsplit40[8][3];
	double mSample_to_s=1.;
	double mSample_to_V=1.;
	std::uint32_t mRunId;
	bool mDoRead = false;
	bool mSaving = false;
	bool mRequestStop = false;
	bool mEndThread = false;
	bool mSaveRaw = false;
	bool mManual = false;
	//char* RawDataBuffer = nullptr;
	QMutex mStopMutex;
	QVector<QFile*> mSaveFile;
	QVector<QTextStream *> outFile;
	QString mFile_prefix;
	QString mFile_folder;
	QString mFile_ftype;
	QString mFile_header;
	QString mFile_format;
	QString mFile_sync;
	QString mRawDataFile;
	int mNEvts_file=0;
	int* mWave_cuts;
	Statistics* mStats;
	dataSaveThread* mSaveThread = nullptr;
	void InitEvtsQueue();
	void SaveEventToFile(const CAENDig2Event *event);
	void SaveEventFast(const CAENDig2Event *event);
	void InitFiles();
	void RunSaveRaw();
	void RunNormal();
	void RunFromFile();
	void RunFromFileManual();
	void V1740UnpackEventCicle(uint32_t* buffin, uint16_t buffout[8][3]);
	int CalcJSamplesShift(uint16_t** data, int NCh, uint64_t trgmask, int* thr, int pretrgsamples, int nextrasamples);
};

#endif
