/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		deviceManagerPanel.h
*	\brief
*	\author
*
******************************************************************************/

#ifndef DEVICEMANAGERPANEL_H
#define DEVICEMANAGERPANEL_H

#include <cstdint>

#include <QWidget>
#include <QPushButton>
#include <QTextEdit>
#include <QTableWidget>
#include <QTableWidgetItem>
#include <QPushButton>
#include <QComboBox>
#include <QString>
#include <QVector>

#include "CAENTreeWidget.h"

namespace Ui {
class deviceManagerPanel;
}

class WaveDump2;

class deviceManagerPanel : public QWidget
{
	Q_OBJECT

public:
	explicit deviceManagerPanel(WaveDump2 *parent = nullptr);
	~deviceManagerPanel();
	CAENTreeWidgetItem *addTreeRoot(const QString& name, int type, std::uint64_t handle);
	void removeDevice(std::uint64_t rootHandle);

signals:
	void showManualController(std::uint64_t handle, const QString&, const QString&, bool f);
	void SetValueManual();

private:
	Ui::deviceManagerPanel * const ui;
	WaveDump2 * const mWaveDump;
	QTextEdit *mPropertyDescription;
	QVector<QTableWidgetItem*> mLabel;
	QVector<QTableWidgetItem*> mPtValue;
	QComboBox *mValues = nullptr;
	QPushButton *mCmdExe = nullptr;
	std::uint64_t mRootHandle;
	QTableWidget *mTableWidget;
	CAENTreeWidgetItem *mRootTreeItem;

	void createPropertyWidget(void);
	QString convertUoM(const char *uom, const char* exp);

private slots:
	void itemClicked2(CAENTreeWidgetItem *itm, int col);
	void manualParamClicked(CAENTreeWidget *itm);
	void manualCommandClicked(CAENTreeWidget *itm);
	void setValue();
	void setValue(const QString &s);
	void sendCMD();
};

#endif // LEFTPANEL_H
