/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		dataSaveThread.h
*	\brief
*	\author
*
******************************************************************************/

#pragma once
#ifndef dataSaveThread_H
#define dataSaveThread_H

#include <QThread>
#include <QMutex>
#include <QWaitCondition>
#include <QVector>
#include <QFile>
#include "CAENDevice.h"
#include "CAENDig2Event.h"
#include "Statistics.h"

class WaveDump2;
class deviceReadoutThread;

class dataSaveThread : public QThread
{
	Q_OBJECT

public:
	dataSaveThread(deviceReadoutThread *parent, WaveDump2 *w, CAENDevice *dev, uint32_t runId);
	~dataSaveThread();
	void run();
	void startRun();
	bool isRunning() { return mDoSave; }
	void setRawdataFilename(QString filename) { mRawDataFile = filename; }
	void InitFiles();
	void StoreStartRunWords(uint64_t *s);
	void StoreStopRunWord(uint64_t s);

signals:
	void GenericError(QString);
	void StopSave();

public slots:
	void stopRun();

private:
	WaveDump2 *mWaveDump2 = nullptr;
	CAENDevice *mDevice = nullptr;
	QString mName;
	std::uint32_t mRunId;
	std::uint16_t mNumOfchannels;
	bool mDoSave = false;
	bool mSaving = false;
	bool mRequestStop = false;
	bool mEndThread = false;
	bool mSaveRaw = false;
	int mNumFile = 0;
	uint64_t mStartRun[4];
	uint64_t mStopRun;
	char mHeader[1050];
	uint32_t mHeaderSize;
	QMutex mStopMutex;
	QVector<QFile*> mSaveFile;
	QVector<QTextStream *> outFile;
	QString mFile_prefix;
	QString mFile_folder;
	QString mFile_ftype;
	QString mFile_header;
	QString mFile_format;
	QString mFile_sync;
	QString mRawDataFile;
	std::uint64_t mChEnableMask;
	int mNEvts_file = 0;
	void SaveRawBuffer(char *buffer, size_t size);
	void RunSaveRaw();
	void WriteFileHeader();
};

#endif
