/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		controlPanel.h
*	\brief
*	\author
*
******************************************************************************/

#ifndef CONTROLPANEL_H
#define CONTROLPANEL_H

#include <QWidget>
#include <QString>

#define TRG_MODE_AUTO 0
#define TRG_MODE_NORMAL 1

namespace Ui {
class controlPanel;
}

class WaveDump2;

class controlPanel : public QWidget
{
	Q_OBJECT

public:
	explicit controlPanel(WaveDump2 *parent = nullptr);
	~controlPanel();
	enum { Software, Self, ExtTrgIn, ExtGPIO, Internal };
	//enum { Auto, Normal };
	void disableAll(bool f);
	void toogleStartStop();
	void setStartStopStatus(int status);
	void updateStartableDevices(int cmd, const QString& name);
	void disableALLOption();
	QString getDevName() const;
	void UpdateCursorsData(QVector<double> pos);
	void updatePreTrgWidget(double max, double min, double incr, double value);
	void updateReclenWidget(double max, double min, double incr, double value);
	void updateSmodeSettings();
	void updateTrgSource(QString trg_src);
	void updateCursorsTrace(QColor color, QString name);
	void updateTrgSettings(int tmode, QString tsource);
	void updatePlotType(int type);
	void WWidgetReclen();
	void WWidgetPreTrg();
	void WWidgetTrgSrc();
	void WWidgetTrgMode();
	void NWidgetReclen();
	void NWidgetPreTrg();
	void NWidgetTrgSrc();
	void NWidgetTrgMode();
	void YUnitChangeCmd(int unit);
	void XUnitChangeCmd(int unit);
	void TriggerModeChangeCmd(int mode);
	void ActiveDevChangeCmd(QString dev);
	void updateGUIForOffline(bool enable);
	void UpdateStartOptions();
	double getPreTrg();
	void enableAllStartPb();
	void CheckTrgSourceOptions(int dev_type,QString trg_src);
	QTimer *trigger_timer;
	
private:

	Ui::controlPanel * const ui;
	WaveDump2 * const mWaveDump;
	bool mIgnoreEvent;
	int mXUnit = 0;
	int mYUnit = 0;
	double mMinR;
	double mMaxR;
	double mIncrR;
	double mMinP;
	double mMaxP;
	double mIncrP;

private slots:
	void cursors_checked(bool checked);
	void ReclenChanged(double reclen);
	void PretrgChanged(double value);
	void XUnitChanged(int unit);
	void YUnitChanged(int unit);
	void TriggerModeChanged(int mode);
	void TriggerSourceChanged(int mode);
	void SetSelfTrgMask();
	void DeviceChanged(QString);

signals:
	void DevChanged(QString);

};

#endif // CONTROLPANEL_H
