/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		boardsListDialog.h
*	\brief
*	\author
*
******************************************************************************/

#pragma once
#ifndef BOARDSLISTDIALOG_H
#define BOARDSLISTDIALOG_H

#include <QDialog>
#include <QString>
#include "ui_boardsListDialog.h"

#define SLAVE_BOARD "SLAVE_%1"

class WaveDump2;

class boardsListDialog : public QDialog
{
	Q_OBJECT

public:
	explicit boardsListDialog(WaveDump2 *parent = Q_NULLPTR, QList<QString> *list=nullptr);
	bool list_modified;
	~boardsListDialog();

private:
	QList<QString> *mDevList;
	Ui::boardsListDialog ui;
	int mrow;

private slots:
	void OkClicked();
	void CancelClicked();
	void MoveUp();
	void MoveDown();
	void BoardSelectedChanged();
};

#endif
