/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		SystemSettings.h
*	\brief
*	\author
*
******************************************************************************/

#pragma once

#include <QDialog>
#include "ui_SystemSettings.h"
#include "CAENDig2Device.h"
#include "ConfigurationPanel.h"
#include "CommonConfigPanel.h"
#include "CommonConfigPanel1.h"

class WaveDump2;

class SystemSettings : public QDialog
{
	Q_OBJECT

public:
	//SystemSettings(WaveDump2 *parent, QVector<uint64_t> dev_handles, QVector<QString> dev_names);
	SystemSettings(WaveDump2 *parent, QList<CAENDevice *> *devices);
	~SystemSettings();

private:
	Ui::SystemSettings ui;
	WaveDump2 *mWaveDump;
	QVector<uint64_t> mHandles;
	QVector<QString> mNames;
	QList<CAENDevice *> *mBoards;
	bool mIgnoreEvents = false;
	QString mSMode;
	QString mTMode;
	int Ndig1_devs = 0;
	int Ndig2_devs = 0;
	QVector<ConfigurationPanel *>config_panels;
	CommonConfigPanel *common_config;
	CommonConfigPanel1 *common_config1;
	void CheckClockSettings();
	void UpdateIOLevel();

private slots:
	void SModeChanged(QString);
	void OfflineSModeChanged(QString);
	void SWHWChanged(QString);
	//void TrgModeChanged(QString);
	void currentTabChanged(int);
	void IOLevelChanged(int);
	void WindowChanged(double);
	void FullMatchingEnable(bool);
};
