/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		Statistics.h
*	\brief
*	\author
*
******************************************************************************/

#pragma once
#ifndef STATISTICS_H
#define STATISTICS_H

#include <QVector>
#include <QDateTime>

class Statistics {

public:
	Statistics();
	~Statistics();

	static void init(int size);
	static void clear();
	static void IncrReadTrgCnt(int dev, int n);
	static void SetReadTrgCnt_prev(int dev, std::uint64_t n);
	static void IncrProcTrgCnt(int dev, int n);
	static void IncrLostTrgCnt(int dev, int n);
	static void IncrBuildMissCnt(int dev, int n);
	static void IncrReadByteCnt(int dev, int n);
	static void SetReadByteCnt_prev(int dev, std::uint64_t n);
	static void IncrGlobalEvCnt(int n);
	static void IncrOutOfSyncEvCnt(int n);
	static void IncrTotBytesCnt(int n);
	static void SetCurrentTimestamp_us(double t) noexcept { mCurrentTimeStamp_us = t; }
	static double getCurrentTimestamp_us() noexcept { return mCurrentTimeStamp_us; }
	static QDateTime getStartDateTime() noexcept { return mStartTime; }
	static void setStartTime(QDateTime start) { mStartTime = start; }
	static std::uint64_t getReadTrgCnt(int dev) { return mReadTrgCnt.at(dev); }
	static std::uint64_t getReadTrgCnt_prev(int dev) { return mReadTrgCnt_prev.at(dev); }
	static std::uint64_t getProcTrgCnt(int dev) { return mProcTrgCnt.at(dev); }
	static std::uint64_t getLostTrgCnt(int dev) { return mLostTrgCnt.at(dev); }
	static std::uint64_t getReadByteCnt(int dev) { return mReadByteCnt.at(dev); }
	static std::uint64_t getReadByteCnt_prev(int dev) { return mReadByteCnt_prev.at(dev); }
	static std::uint64_t getBuildMissCnt(int dev) { return mBuildMissCnt.at(dev); }
	static std::uint64_t getGlobalEvCnt() noexcept { return mGlobalEventCnt; }
	static std::uint64_t getOutOfSyncEvCnt() noexcept { return mOutOfSyncCnt; }
	static std::uint64_t getTotBytesCnt() noexcept { return mTotBytesCnt; }



private:
	static QVector<std::uint64_t> mReadTrgCnt, mReadTrgCnt_prev;		// Transferred Trigger counter (per board)
	static QVector<std::uint64_t> mProcTrgCnt;							// Processed Trigger counter (per board)
	static QVector<std::uint64_t> mLostTrgCnt;							// Lost Trigger counter (per board)
	static QVector<std::uint64_t> mBuildMissCnt;						// Counter of built event where that board is missing (per board)
	static QVector<std::uint64_t> mReadByteCnt, mReadByteCnt_prev;		// Counter of bytes read (per board)
	static uint64_t mTotBytesCnt;										// Read Bytes counter (all boards)
	static uint64_t mGlobalEventCnt;									// Built Event counter (all boards)
	static uint64_t mOutOfSyncCnt;										// Counter of incomplete global events 
	static double mCurrentTimeStamp_us;									// Current processed timestamp
	static QDateTime mStartTime;

};




#endif
