/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		OscilloscopeTools.h
*	\brief
*	\author
*
******************************************************************************/

#pragma once

#include <QWidget>
#include "ui_OscilloscopeTools.h"

#define UOM_PHYS_UNIT 0
#define UOM_SAMPLE    1


class plotPanel;

class OscilloscopeTools : public QWidget
{
	Q_OBJECT

public:
	OscilloscopeTools(plotPanel *parent = Q_NULLPTR);
	~OscilloscopeTools();
	void UpdateGUI();
	void updateXUnit(int unit);
	void updateXMax();
	void updateYMax();
	void updateYUnit(int unit);
	void updateXPos(QVector<double> info);
	void updateTraces();
	void updateOffset(double offset);
	void updateThr(QVector<double> info);
	void plotScaleChanged();
	void refreshXPos();
	void plotTypeChanged(int type);
	void enableOfflineMode(bool enable);
	void setActiveDevClass(int dclass);

private:
	Ui::OscilloscopeTools ui;
	plotPanel *mPlot;
	bool mIgnoreEvent = false;
	int mUomx = UOM_SAMPLE;
	int mUomy=UOM_SAMPLE;
	double maxX;
	double minX;
	double maxY;
	double minY;
	double maxXPos;
	double maxThr;
	int mDClass = 0;
	QIcon createIcon(QColor color);

private slots:
	void XChanged(int);
	void YChanged(int);
	void XPosChanged(int);
	void XPosChanged(double);
	void OffsetChanged(int);
	void OffsetChanged(double);
	void ActiveTraceChanged(int);
	void ThrChanged(double);
	void OffsetToAll();
	void ThresholdToAll();

};
