/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		FFT.h
*	\brief
*	\author
*
******************************************************************************/

#pragma once
#ifndef FFT_H
#define FFT_H

#include <cstdint>
#include <QVector>

// Types of windowing
#define HANNING_FFT_WINDOW    0
#define HAMMING_FFT_WINDOW    1
#define BLACKMAN_FFT_WINDOW   2
#define RECT_FFT_WINDOW       3

#define FFT_BASELINE  0.0000001  // Baseline for low clipping (-140dB)

class FFT
{
private:
	// raw Data array and length
	int m_rawDataLength;
	QVector<double> m_x;
	QVector<double> m_y;

public:
	FFT(void);
	void Init(int Wsamples);
	int NSamplesFFT(int Wsamples, int *M);
	int CalculateFFT(std::uint16_t* wave, int ns, int Nbit, int WindowType, double* fft);

	virtual ~FFT(void);
};

#endif

