/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		Dx740V1ConfigPanel.h
*	\brief
*	\author
*
******************************************************************************/

#pragma once
#ifndef DX740V1CONFIGPANEL_H
#define DX740V1CONFIGPANEL_H

#include <QWidget>
#include <QDialog>
#include "ui_Dx740V1ConfigPanel.h"
#include "CAENPushButton.h"
#include "CAENparameter.h"
#include "ConfigurationPanel.h"
#include "CAENDig1Device.h"

#define TRG_MODE_LINEAR 0
#define TRG_MODE_FIXED  1

class WaveDump2;

class Dx740V1ConfigPanel : public QDialog, public ConfigurationPanel
{
	Q_OBJECT

public:
	explicit Dx740V1ConfigPanel(WaveDump2 *parent, CAENDig1Device *dev, QString dev_name, bool show_wait);
	~Dx740V1ConfigPanel();
	void Update();

public slots:
	void TriggerModeChanged(QString);

private slots:
	void channelClicked(CAENPushButton *pb);
	void selectAll();
	void intChanged(int val);
	void boolChanged(bool val);
	void doubleChanged(double val);
	void itemCheckedChanged(QListWidgetItem *item);
	void MultiClicked();
	void TrgoutChanged(QString);
	void SetMask();
	void SetTrgoutMask();
	void currentTabChanged(int tab);
	void TextChanged(QString);
	void UpdateSamplFreq();
	void PreTrgChanged(double);
	void TrgSourceChanged(QListWidgetItem *item);
	void ClockSourceChanged(int);
	void calibrateADC();


private:
	Ui::Dx740V1ConfigPanel *ui;
	WaveDump2 *mWaveDump;
	CAENDig1Device* mDev;
	CAENPushButton *mPbCh[64];
	int mNumberOfChannels;
	int mGainGroupSize;
	int mChGroupSize = 1;
	uint64_t mDevHandle;
	QString mDevName;
	int mNumberOfChParams;
	int mNumberOfGroupParams;
	int mFirstSelectedCh=0;
	QVector<int> mFirstSelectedGroup;
	bool mMulti;
	int mUoMX;
	int mUoMY;
	bool mVGAGainVisible = false;
	bool mCHGainVisible = false;
	bool mDecimationVisible = false;
	bool mGroupedChannels = false;
	void CreateChParamsMap();
	void CreateGroupParamsMap();
	void connectWidgets();
	void FillParamsAndWidgetsList();
	void createMaps();
	void UpdateDevGUI();
	void UpdateChGUI();
	void UpdateGroupGUI();
	void defineScaleParams();
	void CheckChParamValues();
	void CheckGroupParamValues();
	void ApplyNewValue(QWidget *widget);
	void WarningWidget(QWidget *widget, bool bold);
	void NormalWidget(QWidget *widget, bool bold);
	void UpdateParamsUoM();
	void UpdateTriggerMode();
	void UpdateTrgoutMode();
	void UpdateMainSettings();
	void UpdateRelatedParams(QWidget *widget);
	void UpdatePreTrigger();
	void UpdateClkSource();
};

#endif // TOPPANEL_H
