/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		DACOUTDialog.h
*	\brief
*	\author
*
******************************************************************************/

#pragma once

#include <QDialog>
#include "ui_DACOUTDialog.h"

class DACOUTDialog : public QDialog
{
	Q_OBJECT

public:
	DACOUTDialog(QWidget *parent = Q_NULLPTR, uint64_t Handle=0);
	~DACOUTDialog();

private:
	Ui::DACOUTDialog ui;
	uint64_t mHandle;

private slots:
	void OkClicked();
	void ModeChanged(int mode);
	void LevelChanged(double l);
	void HighLevelChanged(double l);
	void LowLevelChanged(double l);
	void ChChanged(int ch);
	void TChanged(double T);
	void WChanged(double w);

};
