/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		ConfigurationPanel.h
*	\brief
*	\author
*
******************************************************************************/

#ifndef CONFIGURATIONPANEL_H
#define CONFIGURATIONPANEL_H

#include <QWidget>
#include "CAENparameter.h"

class ConfigurationPanel{

public:
    ConfigurationPanel(){ }
    ~ConfigurationPanel() { Clear(); }
    void Init();
	void Clear();
	virtual void Update();
	

protected:

    // Flags
    bool mIgnoreEvent = false;
	QStringList mDevParamsList;
	QStringList mChParamsList;
	QStringList mGroupParamsList;
	QVector<int> mGroupsize;
    QVector<QWidget *> mDevWidgetsList;
	QVector<QWidget *> mChWidgetsList;
	QVector<QWidget*> mGroupWidgetsList;
	QHash<QWidget *, CAENparameter *> mDevGUIMap;
	QHash<QWidget *, CAENparameter *> mChGUIMap;
	QHash<QWidget*, CAENparameter*> mGroupGUIMap;
	QVector<CAENparameter *> mChParams;
	QVector<CAENparameter*> mGroupParams;

    virtual void connectWidgets() = 0;
	virtual void FillParamsAndWidgetsList() = 0;
	virtual void createMaps() = 0;
	virtual void ApplyNewValue(QWidget *widget) = 0;
    virtual void updateDevGUI();
	virtual void updateChGUI();
	virtual void updateGroupGUI();
	virtual void defineScaleParams() = 0;

};

#endif // CONFIGURATIONPANEL_H
