/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		CommonConfigPanel1.h
*	\brief
*	\author
*
******************************************************************************/

#pragma once
#ifndef COMMONCONFIGPANEL1_H
#define COMMONCONFIGPANEL1_H

#include <QWidget>
#include <QDialog>
#include "ui_CommonConfigPanel1.h"
#include "CAENPushButton.h"
#include "CAENparameter.h"
#include "CAENDig1Device.h"

#define TRG_MODE_LINEAR 0
#define TRG_MODE_FIXED  1

class WaveDump2;
/*
typedef struct {
	QVector<QString> allowed_values;
	QString max;
	QString min;
	QString incr;
}ParamInfo;*/

class CommonConfigPanel1 : public QDialog
{
	Q_OBJECT

public:
	explicit CommonConfigPanel1(WaveDump2 *parent, QVector<CAENDig1Device*> devs, bool show_wait);
	~CommonConfigPanel1();

public slots:
	void TriggerModeChanged(QString);

private slots:
	void channelClicked(CAENPushButton *pb);
	void selectAll();
	void intChanged(int val);
	void boolChanged(bool val);
	void doubleChanged(double val);
	void itemCheckedChanged(QListWidgetItem *item);
	void MultiClicked();
	void TrgoutChanged(QString);
	void SetMask();
	void SetTrgoutMask();
	void currentTabChanged(int tab);
	void TextChanged(QString);
	void PreTrgChanged(double);
	void TrgSourceChanged(QListWidgetItem *item);
	void ClockSourceChanged(int);
	void EnableChanged(int index);
	void ThrChanged(double val);
	void DCOChanged(double val);


private:
	Ui::CommonConfigPanel1 *ui;
	WaveDump2 *mWaveDump;
	CAENPushButton *mPbCh[64];
	int mNumBrds=1;
	bool mCHGainVisible = false;
	bool mDecimationVisible = false;
	QVector<uint64_t> mNumberOfChannels;
	QVector<CAENDig1Device *> mDevs;
	QString mDevName = "COMMON1";
	int mNumberOfChParams;
	int mNumberOfGroupParams;
	int mFirstSelectedCh=0;
	QVector<int> mFirstSelectedGroup;
	bool mMulti;
	int mUoMX;
	int mUoMY;
	bool mIgnoreEvent;
	QStringList mDevParamsList;
	QStringList mChParamsList;
	QStringList mGroupParamsList;
	QStringList mDevRelatedParamsList;
	QStringList mChRelatedParamsList;
	QStringList mGroupRelatedParamsList;
	QVector<ParamInfo> mDevParamsInfo;
	QVector<ParamInfo> mChParamsInfo;
	QVector<ParamInfo> mGroupParamsInfo;
	QVector<int> multipleValue;
	QVector<QWidget*> mDevWidgetsList;
	QVector<QWidget*> mChWidgetsList;
	QVector<QWidget*> mGroupWidgetsList;
	QVector<int> mGroupsize;
	QVector<int> mDevWithCHGain;
	QVector<int> mDevWithDecim;
	QVector<int> mDevWithGroupedChannels;
	QVector<int> mChGroupSize;
	int mMinGroupSize = 100;
	QHash<QWidget*, QString> mDevGUIMap;
	QHash<QWidget*, QString> mChGUIMap;
	QHash<QWidget*, QString> mGroupGUIMap;
	QVector<QWidget*> mWwithUoMX;
	QVector<QWidget*> mWwithUoMY;
	void connectWidgets();
	void FillParamsAndWidgetsList();
	void createMaps();
	void UpdateDevGUI();
	void UpdateChGUI();
	void UpdateGroupGUI();
	void defineScaleParams();
	void CheckChParamValues();
	void CheckGroupParamValues();
	void ApplyNewValue(QWidget *widget);
	void WarningWidget(QWidget *widget, bool bold);
	void NormalWidget(QWidget *widget, bool bold);
	void UpdateParamsUoM();
	void UpdateTriggerMode();
	void UpdateTrgoutMode();
	void UpdateMainSettings();
	void UpdatePreTrigger();
	void UpdateEnable();
	void UpdateThr();
	void UpdateDCO();
	void UpdateClkSource();
	void FillParamsInfo();
	void fillInfo(QString qry, ParamInfo* info);
	double getScaleParamValue(int b, QString qry);
	void UpdateWidget(QWidget* widget, ParamInfo info, QString value);
	int SetDevParamValueFromWidget(QWidget* widget, QString qry);
	int CommonSetParam(QString qry, QString value, int ch, QString rpar, QString* set_value);
	QString GetValueToSetFromWidget(QWidget* widget, bool* check_uom);
};

#endif // TOPPANEL_H
