/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		CommonConfigPanel.h
*	\brief
*	\author
*
******************************************************************************/

#pragma once
#ifndef COMMONCONFIGPANEL_H
#define COMMONCONFIGPANEL_H

#include <QWidget>
#include <QDialog>
#include "ui_CommonConfigPanel.h"
#include "CAENPushButton.h"
#include "CAENparameter.h"

#define TRG_MODE_LINEAR 0
#define TRG_MODE_FIXED  1

class WaveDump2;
/*
typedef struct {
	QVector<QString> allowed_values;
	QString max;
	QString min;
	QString incr;
}ParamInfo;*/


class CommonConfigPanel : public QDialog
{
	Q_OBJECT

public:
	explicit CommonConfigPanel(WaveDump2 *parent, QVector<uint64_t> dev_handles);
	~CommonConfigPanel();

public slots:
	void TriggerModeChanged(QString);

private slots:
	void channelClicked(CAENPushButton *pb);
	void selectAll();
	void intChanged(int val);
	void boolChanged(bool val);
	void doubleChanged(double val);
	void itemCheckedChanged(QListWidgetItem *item);
	void MultiClicked();
	void VetoChanged(QString mode);
	void GpioChanged(QString mode);
	void SetMask();
	void SetTrgoutMask();
	void currentTabChanged(int tab);
	void TextChanged(QString);
	void TrgoutChanged(QString);
	void SetPermanentClockDelay();

private:
	Ui::CommonConfigPanel *ui;
	WaveDump2 *mWaveDump;
	CAENPushButton *mPbCh[64];
	int mNumBrds;
	bool mVGAGainVisible=false;
	bool mCHGainVisible = false;
	bool mDecimationVisible = false;
	QVector<uint64_t> mNumberOfChannels;
	QVector<uint64_t> mDevHandle;
	QStringList mDevParamsList;
	QStringList mChParamsList;
	QStringList mGroupParamsList;
	QStringList mDevRelatedParamsList;
	QVector<ParamInfo> mDevParamsInfo;
	QVector<ParamInfo> mChParamsInfo;
	QVector<ParamInfo> mGroupParamsInfo;
	QVector<int> multipleValue;
	QVector<QWidget *> mDevWidgetsList;
	QVector<QWidget *> mChWidgetsList;
	QVector<QWidget*> mGroupWidgetsList;
	QVector<int> mGroupsize;
	QVector<int> mDevWithVGAGain;
	QVector<int> mDevWithCHGain;
	QVector<int> mDevWithDecim;
	QHash<QWidget *, QString> mDevGUIMap;
	QHash<QWidget *, QString> mChGUIMap;
	QHash<QWidget*, QString> mGroupGUIMap;
	QVector<QWidget *> mWwithUoMX;
	QVector<QWidget *> mWwithUoMY;
	int mNumberOfChParams;
	int mFirstSelectedCh=0;
	int mNumberOfGroupParams;
	QVector<int> mFirstSelectedGroup;
	bool mMulti;
	int mUoMX;
	int mUoMY;
	bool mIgnoreEvent = false;
	QString mDevName;
	void connectWidgets();
	void FillParamsAndWidgetsList();
	void createMaps();
	void UpdateDevGUI();
	void UpdateChGUI();
	void UpdateGroupGUI();
	void defineScaleParams();
	void UpdateMainSettings();
	void UpdateTrgoutMode();
	void UpdateVetoSrc();
	void UpdateGpioMode();
	void UpdateParamsUoM();
	void CheckChParamValues();
	void CheckGroupParamValues();
	void ApplyNewValue(QWidget *widget);
	void WarningWidget(QWidget *widget, bool bold);
	void NormalWidget(QWidget *widget, bool bold);
	void UpdateTriggerMode();
	int CommonSetParam(QString qry, QString value, int ch, QString rpar, QString *set_value);
	void UpdateWidget(QWidget *widget, ParamInfo info, QString value);
	int SetDevParamValueFromWidget(QWidget *widget, QString qry);
	QString GetValueToSetFromWidget(QWidget *widget, bool *check_uom);
	void FillParamsInfo();
	void fillInfo(QString qry, ParamInfo *info);
	double getScaleParamValue(int b, QString qry);

};

#endif 
