/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		CAENparameter.h
*	\brief
*	\author
*
******************************************************************************/

#pragma once
#ifndef CAENPARAMETER_H
#define CAENPARAMETER_H

#include <cstdint>
#include <QWidget>
#include <QComboBox>
#include <QSpinBox>
#include <QDoubleSpinBox>
#include <QGroupBox>
#include <QRadioButton>
#include <QPushButton>
#include <QLineEdit>
#include <QCheckBox>
#include <QListWidget>
#include <CAEN_FELib.h>

#define UOM_SAMPLES "S"
#define UOM_TIME "T"

typedef struct {
	QVector<QString> allowed_values;
	QString max;
	QString min;
	QString incr;
}ParamInfo;

class CAENparameter
{
public:
	CAENparameter(uint64_t pHandle);
	~CAENparameter();
	QString getName() const noexcept { return mName; }
	CAEN_FELib_NodeType_t getType() const noexcept { return mType; }
	QString getQry() const noexcept { return mPath; }
	std::uint64_t getHandle() const noexcept { return mHandle; }
	QString getValue();
	QString getCachedValue() const noexcept { return mValue; }
	QString getDataType() const noexcept { return mDataType; }
	void setValue(QString val);
	const QVector<QString>& getAllowedValues() { return mValues; }
	QVector<CAENparameter *> RelatedParams;
	void SetWidget(QWidget *widget);
	void UpdateWidget();
	void SetValueFromWidget();
	double getMin() const noexcept { return mMin; }
	double getMax() const noexcept { return mMax; }
	double getIncr() const noexcept { return mIncr; }
	void setUoMGUI(QString uom) noexcept { mUoMGUI = uom; }
	void setUoMToGUIUoM(double factor) noexcept  { mUoM_to_GUIUoM = factor; }
	void setUoMToGUIUoM_incr(double val) noexcept { mUoM_to_GUIUoM_offset = val; }
	void setScaleFactorParam(uint64_t fh) noexcept { mScaleParamHandle = fh; mHasScaleFactor = true; }
	void addRelatedParam(CAENparameter *param) { RelatedParams.push_back(param); }

private:
	uint64_t mHandle;
	QString mName;
	QString mPath;
	CAEN_FELib_NodeType_t mType;
	QString mAccType;
	QString mUoM;
	QString mMultiValue;
	QString mDataType;
	int mUoMExp;
	QString mUoMGUI;
	double mUoM_to_GUIUoM=1.;
	double mUoM_to_GUIUoM_offset = 0.;
	double mMin;
	double mMax;
	double mIncr;
	QString mIncrStr;
	QString mValue;
	QWidget *mWidget;
	QVector<QString> mValues;
	bool mHasScaleFactor=false;
	uint64_t mScaleParamHandle;
	void fillInfo();
	void fillAllowedValues();
	void updateComboBox(QComboBox *cbox);
	void updateSpinBox(QSpinBox *sbox);
	void updateDoubleSpinBox(QDoubleSpinBox *dbox);
	void updateGroupBox(QGroupBox *gbox);
	void updateLineEdit(QLineEdit *ledit);
	void updateListWidget(QListWidget *lwidget);
	void updateCheckBox(QCheckBox* cbox);
	void setValuefromComboBox(QComboBox *cbox);
	void setValuefromSpinBox(QSpinBox *sbox);
	void setValuefromDoubleSpinBox(QDoubleSpinBox *dbox);
	void setValuefromGroupBox(QGroupBox *gbox);
	void setValuefromLineEdit(QLineEdit *ledit);
	void setValuefromListWidget(QListWidget *lwidget);
	void setValuefromCheckBox(QCheckBox* cbox);
	static QString GetUoMString(QString uom, int exp);
	static QString UoMshort(QString uom);
	double getScaleParamValue();

};


#endif

