/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		CAENTreeWidgetItem.h
*	\brief
*	\author
*
******************************************************************************/

#ifndef CAENTREEWIDGETITEM_H
#define CAENTREEWIDGETITEM_H

#include <cstdint>

#include <QTreeWidgetItem>
#include <QString>

#include <CAEN_FELib.h>

class CAENTreeWidgetItem: public QTreeWidgetItem
{

public:
	CAENTreeWidgetItem(CAENTreeWidgetItem *parent, QStringList &name, int type, std::uint64_t handle, const QString& qry);
	CAENTreeWidgetItem(QStringList &name, int type, std::uint64_t handle, const QString& qry);
	CAENTreeWidgetItem();
	CAENTreeWidgetItem(int type);
	CAENTreeWidgetItem(CAENTreeWidgetItem *parent, int type);
	void setHandle(std::uint64_t handle);
	void setType(CAEN_FELib_NodeType_t type);
	void setQry(const QString& qry);
	CAEN_FELib_NodeType_t getType() const;
	std::uint64_t getHandle() const;
	const QString& getQry() const;
	const QString& getRootName() const;
	void setRootName(const QString& name);

private:
	QString mRootName;
	std::uint64_t mHandle;
	CAEN_FELib_NodeType_t mType;
	QString mQry;

};

#endif // CAENTREEWIDGETITEM_H
