/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		CAENTreeWidget.h
*	\brief
*	\author
*
******************************************************************************/

#ifndef CAENTREEWIDGET_H
#define CAENTREEWIDGET_H

#include <cstdint>

#include <QObject>
#include <QString>
#include <QTreeWidget>

#include "CAENTreeWidgetItem.h"

class CAENTreeWidget: public QTreeWidget
{
	Q_OBJECT

public:
	CAENTreeWidget(QWidget *parent);
	std::uint64_t getItemHandle() const;
	const QString& getQuery() const;
	const QString& getRootName() const;
private:
	std::uint64_t mItemHandle;
	QString mQry;
	QString mRootName;

signals:
	void itemClickedSignal(CAENTreeWidgetItem*, int);
	void manualPClickedSignal(CAENTreeWidget*);
	void manualCClickedSignal(CAENTreeWidget*);

private slots:
	void onCustomContextMenuRequested(const QPoint& pos);
	void showContextMenu(void* item, const QPoint& globalPos);
	void showManualCClicked();
	void showManualPClicked();
	void itemClickedSlot(QTreeWidgetItem* itm, int col);
};

#endif // CAENTREEWIDGET_H
