/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		CAENFELibException.h
*	\brief
*	\author
*
******************************************************************************/

#pragma once
#ifndef CAENFELIBEXCEPTION_H
#define CAENFELIBEXCEPTION_H

#include <QWidget>

#include <stdexcept>

class CAENFELibException : public std::runtime_error
{
public:
	CAENFELibException(QString message, int RetCode);
	int ErrorCode() const noexcept { return mErrCode; }
	QString Message() const noexcept { return mMessage; }
	QString ErrorMessage() const noexcept { return mErrorMessage; }

private:
	QString mMessage;
	QString mErrorName;
	QString mErrorDescription;
	QString mErrorMessage;
	int mErrCode;
};

#endif
