/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2020-2022 CAEN SpA
*
*	This file is part of WaveDump2.
*
*	WaveDump2 is free software; you can redistribute it and/or
*	it under the terms of the GNU General Public License as published
*	by the Free Software Foundation; either version 3 of the License, or
*	(at your option) any later version.
*
*	WaveDump2 is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with WaveDump2; if not, see https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: GPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		CAENDig2Script.h
*	\brief
*	\author
*
******************************************************************************/

#pragma once
#ifndef CAENDIG2SCRIPT_H
#define CAENDIG2SCRIPT_H
#include <QObject>
#include <QFile>
#include <QTextStream>
#include "CAENparameter.h"

#define ACTION_SW  "SW_OPTION"
#define ACTION_HW  "HW_OPTION"

#define YUNIT_CHANGE          "YUNIT_CHANGE"_h
#define XUNIT_CHANGE          "XUNIT_CHANGE"_h
#define TOOLS_SHOW            "TOOLS_SHOW"_h
#define PLOT_FREEZE           "PLOT_FREEZE"_h
#define PALETTE_SHOW          "PALETTE_SHOW"_h
#define LOG_SHOW              "LOG_SHOW"_h
#define STATS_SHOW            "STATS_SHOW"_h
#define MANUAL_SHOW			  "MANUAL_SHOW"_h
#define DEVMANAGER_SHOW       "DEVMANAGER_SHOW"_h
#define PLOTTYPE_CHANGE       "PLOTTYPE_CHANGE"_h
#define NWAVES_SET            "NWAVES_SET"_h
#define START_ACQ             "START_ACQ"_h
#define STOP_ACQ              "STOP_ACQ"_h
#define ACTIVE_DEV_CHANGE     "ACTIVE_DEV_CHANGE"_h
#define TRIGGER_MODE_CHANGE   "TRIGGER_MODE_CHANGE"_h
#define SEND_SW_TRIGGER       "SEND_SW_TRIGGER"_h
#define SAVE_FOLDER_CHANGE    "SAVE_FOLDER_CHANGE"_h
#define FILE_PREFIX_CHANGE    "FILE_PREFIX_CHANGE"_h
#define FILE_TYPE_CHANGE      "FILE_TYPE_CHANGE"_h
#define FILE_FORMAT_CHANGE    "FILE_FORMAT_CHANGE"_h
#define FILE_HEADER_ENABLE    "FILE_HEADER_ENABLE"_h
#define FILE_SYNC_UNIQUE	  "FILE_SYNC_UNIQUE"_h
#define DATA_SAVE_ENABLE      "DATA_SAVE_ENABLE"_h
#define GLOBAL_S_MODE_CHANGE  "GLOBAL_START_MODE_CHANGE"_h
#define GLOBAL_T_MODE_CHANGE  "GLOBAL_TRIGGER_MODE_CHANGE"_h
#define CINC_WIN_SET		  "COINCIDENCE_WINDOW_CHANGE"_h	
#define FULLY_MATCHING_EVENTS "FULLY_MATCHING_EVENTS_ONLY"_h
#define MAX_NEVTS_FILE		  "FILE_MAX_NEVTS"_h

#ifdef WIN32
#define ENDL  "\r\n"
#define DIRSEP "/"
#else
#define ENDL  "\n"
#define DIRSEP "/"
#endif

class CAENDig2Script
{

public:
	CAENDig2Script(QString filename);
	~CAENDig2Script();
	void AddAction(QString action, QString dev_name, QString pr_name, QString value);
	void AddSWAction(QString action, QString value);
	


private:
	QString mFilename;
	QTextStream mout;
	QFile* mFile;
};

#endif
